/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.runtime;

import io.quarkus.restclient.runtime.BuilderResolver;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Set;
import javax.ws.rs.RuntimeType;
import org.eclipse.microprofile.rest.client.spi.RestClientBuilderResolver;
import org.jboss.resteasy.core.providerfactory.ClientHelper;
import org.jboss.resteasy.core.providerfactory.NOOPServerHelper;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.microprofile.client.RestClientBuilderImpl;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Recorder
public class RestClientRecorder {
    public void setRestClientBuilderResolver() {
        RestClientBuilderResolver.setInstance((RestClientBuilderResolver)new BuilderResolver());
    }

    public void setSslEnabled(boolean sslEnabled) {
        RestClientBuilderImpl.setSslEnabled((boolean)sslEnabled);
    }

    public void initializeResteasyProviderFactory(final RuntimeValue<InjectorFactory> injectorFactory, boolean useBuiltIn, Set<String> providersToRegister, Set<String> contributedProviders) {
        ResteasyProviderFactoryImpl clientProviderFactory = new ResteasyProviderFactoryImpl(null, true){

            public RuntimeType getRuntimeType() {
                return RuntimeType.CLIENT;
            }

            protected void initializeUtils() {
                this.clientHelper = new ClientHelper((ResteasyProviderFactoryImpl)this);
                this.serverHelper = NOOPServerHelper.INSTANCE;
            }

            public InjectorFactory getInjectorFactory() {
                return (InjectorFactory)injectorFactory.getValue();
            }
        };
        if (useBuiltIn) {
            RegisterBuiltin.register((ResteasyProviderFactory)clientProviderFactory);
            RestClientRecorder.registerProviders((ResteasyProviderFactory)clientProviderFactory, contributedProviders, false);
        } else {
            providersToRegister.removeAll(contributedProviders);
            RestClientRecorder.registerProviders((ResteasyProviderFactory)clientProviderFactory, providersToRegister, true);
            RestClientRecorder.registerProviders((ResteasyProviderFactory)clientProviderFactory, contributedProviders, false);
        }
        RestClientBuilderImpl.setProviderFactory((ResteasyProviderFactory)clientProviderFactory);
    }

    private static void registerProviders(ResteasyProviderFactory clientProviderFactory, Set<String> providersToRegister, Boolean isBuiltIn) {
        for (String providerToRegister : providersToRegister) {
            try {
                clientProviderFactory.registerProvider(Thread.currentThread().getContextClassLoader().loadClass(providerToRegister.trim()), isBuiltIn.booleanValue());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to find class for provider " + providerToRegister, e);
            }
        }
    }
}

