/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods.hal;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.hal.HalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import javax.ws.rs.core.Response;

public final class UpdateHalMethodImplementor
extends HalMethodImplementor {
    private static final String METHOD_NAME = "updateHal";
    private static final String RESOURCE_UPDATE_METHOD_NAME = "update";
    private static final String RESOURCE_GET_METHOD_NAME = "get";

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = classCreator.getMethodCreator(METHOD_NAME, Response.class.getName(), new String[]{resourceMetadata.getIdType(), resourceMetadata.getEntityType()});
        this.addPathAnnotation((AnnotatedElement)methodCreator, this.appendToPath(resourceProperties.getMethodPath(RESOURCE_UPDATE_METHOD_NAME), "{id}"));
        this.addTransactionalAnnotation((AnnotatedElement)methodCreator);
        this.addPutAnnotation((AnnotatedElement)methodCreator);
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        this.addConsumesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle entityToSave = methodCreator.getMethodParam(1);
        BranchResult entityExists = this.doesEntityExist((BytecodeCreator)methodCreator, resourceMetadata.getResourceClass(), resource, id);
        this.updateAndReturn(entityExists.trueBranch(), resourceMetadata.getResourceClass(), resource, id, entityToSave);
        this.createAndReturn(entityExists.falseBranch(), resourceMetadata.getResourceClass(), resource, id, entityToSave);
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return RESOURCE_UPDATE_METHOD_NAME;
    }

    private BranchResult doesEntityExist(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id) {
        ResultHandle entity = creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceClass, (String)RESOURCE_GET_METHOD_NAME, Object.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id});
        return creator.ifNotNull(entity);
    }

    private void createAndReturn(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id, ResultHandle entityToSave) {
        ResultHandle entity = creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceClass, (String)RESOURCE_UPDATE_METHOD_NAME, Object.class, (Object[])new Object[]{Object.class, Object.class}), resource, new ResultHandle[]{id, entityToSave});
        ResultHandle wrapper = this.wrapHalEntity(creator, entity);
        ResultHandle entityUrl = ResponseImplementor.getEntityUrl(creator, entity);
        creator.returnValue(ResponseImplementor.created(creator, wrapper, entityUrl));
    }

    private void updateAndReturn(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id, ResultHandle entityToSave) {
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceClass, (String)RESOURCE_UPDATE_METHOD_NAME, Object.class, (Object[])new Object[]{Object.class, Object.class}), resource, new ResultHandle[]{id, entityToSave});
        creator.returnValue(ResponseImplementor.noContent(creator));
    }
}

