/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.jackson.spi.JacksonModuleBuildItem;
import io.quarkus.jsonb.spi.JsonbSerializerBuildItem;
import io.quarkus.rest.data.panache.deployment.JaxRsResourceImplementor;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.RestDataResourceBuildItem;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.properties.ResourcePropertiesBuildItem;
import io.quarkus.rest.data.panache.deployment.properties.ResourcePropertiesProvider;
import io.quarkus.rest.data.panache.runtime.hal.HalCollectionWrapper;
import io.quarkus.rest.data.panache.runtime.hal.HalCollectionWrapperJacksonSerializer;
import io.quarkus.rest.data.panache.runtime.hal.HalCollectionWrapperJsonbSerializer;
import io.quarkus.rest.data.panache.runtime.hal.HalEntityWrapper;
import io.quarkus.rest.data.panache.runtime.hal.HalEntityWrapperJacksonSerializer;
import io.quarkus.rest.data.panache.runtime.hal.HalEntityWrapperJsonbSerializer;
import io.quarkus.rest.data.panache.runtime.hal.HalLink;
import io.quarkus.rest.data.panache.runtime.hal.HalLinkJacksonSerializer;
import io.quarkus.rest.data.panache.runtime.hal.HalLinkJsonbSerializer;
import java.util.Arrays;
import java.util.List;
import org.jboss.resteasy.links.impl.EL;

public class RestDataProcessor {
    @BuildStep
    void implementResources(CombinedIndexBuildItem index, List<RestDataResourceBuildItem> resourceBuildItems, List<ResourcePropertiesBuildItem> resourcePropertiesBuildItems, BuildProducer<GeneratedBeanBuildItem> implementationsProducer) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(implementationsProducer);
        JaxRsResourceImplementor jaxRsResourceImplementor = new JaxRsResourceImplementor();
        ResourcePropertiesProvider resourcePropertiesProvider = new ResourcePropertiesProvider(index.getIndex());
        for (RestDataResourceBuildItem resourceBuildItem : resourceBuildItems) {
            ResourceMetadata resourceMetadata = resourceBuildItem.getResourceMetadata();
            ResourceProperties resourceProperties = this.getResourceProperties(resourcePropertiesProvider, resourceMetadata, resourcePropertiesBuildItems);
            if (!resourceProperties.isExposed()) continue;
            jaxRsResourceImplementor.implement((ClassOutput)classOutput, resourceMetadata, resourceProperties);
        }
    }

    @BuildStep
    JacksonModuleBuildItem registerJacksonSerializers() {
        return new JacksonModuleBuildItem.Builder("hal-wrappers").addSerializer(HalEntityWrapperJacksonSerializer.class.getName(), HalEntityWrapper.class.getName()).addSerializer(HalCollectionWrapperJacksonSerializer.class.getName(), HalCollectionWrapper.class.getName()).addSerializer(HalLinkJacksonSerializer.class.getName(), HalLink.class.getName()).build();
    }

    @BuildStep
    JsonbSerializerBuildItem registerJsonbSerializers() {
        return new JsonbSerializerBuildItem(Arrays.asList(HalEntityWrapperJsonbSerializer.class.getName(), HalCollectionWrapperJsonbSerializer.class.getName(), HalLinkJsonbSerializer.class.getName()));
    }

    @BuildStep
    RuntimeInitializedClassBuildItem el() {
        return new RuntimeInitializedClassBuildItem(EL.class.getCanonicalName());
    }

    private ResourceProperties getResourceProperties(ResourcePropertiesProvider resourcePropertiesProvider, ResourceMetadata resourceMetadata, List<ResourcePropertiesBuildItem> resourcePropertiesBuildItems) {
        for (ResourcePropertiesBuildItem resourcePropertiesBuildItem : resourcePropertiesBuildItems) {
            if (!resourcePropertiesBuildItem.getResourceType().equals(resourceMetadata.getResourceClass()) && !resourcePropertiesBuildItem.getResourceType().equals(resourceMetadata.getResourceInterface())) continue;
            return resourcePropertiesBuildItem.getResourcePropertiesInfo();
        }
        return resourcePropertiesProvider.getForInterface(resourceMetadata.getResourceInterface());
    }
}

