/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods.hal;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.hal.HalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import io.quarkus.rest.data.panache.runtime.jta.TransactionalExecutor;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.ws.rs.core.Response;

public final class UpdateHalMethodImplementor
extends HalMethodImplementor {
    private static final String METHOD_NAME = "updateHal";
    private static final String RESOURCE_UPDATE_METHOD_NAME = "update";
    private static final String RESOURCE_GET_METHOD_NAME = "get";
    private final boolean withValidation;

    public UpdateHalMethodImplementor(boolean withValidation) {
        this.withValidation = withValidation;
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = classCreator.getMethodCreator(METHOD_NAME, Response.class, new Object[]{resourceMetadata.getIdType(), resourceMetadata.getEntityType()});
        this.addPathAnnotation((AnnotatedElement)methodCreator, this.appendToPath(resourceProperties.getPath(RESOURCE_UPDATE_METHOD_NAME), "{id}"));
        this.addPutAnnotation((AnnotatedElement)methodCreator);
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        this.addConsumesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        if (this.withValidation) {
            methodCreator.getParameterAnnotations(1).addAnnotation(Valid.class);
        }
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle entityToSave = methodCreator.getMethodParam(1);
        TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, "Failed to update an entity");
        ResultHandle transactionalExecutor = this.getTransactionalExecutor((BytecodeCreator)tryBlock);
        ResultHandle updateFunction = this.getUpdateFunction((BytecodeCreator)tryBlock, resourceMetadata.getResourceClass(), resource, id, entityToSave);
        ResultHandle newEntity = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(TransactionalExecutor.class, (String)"execute", Object.class, (Class[])new Class[]{Supplier.class}), transactionalExecutor, new ResultHandle[]{updateFunction});
        BranchResult createdNewEntity = tryBlock.ifNotNull(newEntity);
        ResultHandle wrappedNewEntity = this.wrapHalEntity(createdNewEntity.trueBranch(), newEntity);
        ResultHandle newEntityUrl = ResponseImplementor.getEntityUrl(createdNewEntity.trueBranch(), newEntity);
        createdNewEntity.trueBranch().returnValue(ResponseImplementor.created(createdNewEntity.trueBranch(), wrappedNewEntity, newEntityUrl));
        createdNewEntity.falseBranch().returnValue(ResponseImplementor.noContent(createdNewEntity.falseBranch()));
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return RESOURCE_UPDATE_METHOD_NAME;
    }

    private ResultHandle getUpdateFunction(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id, ResultHandle entity) {
        FunctionCreator functionCreator = creator.createFunction(Supplier.class);
        BytecodeCreator functionBytecodeCreator = functionCreator.getBytecode();
        AssignableResultHandle entityToSave = functionBytecodeCreator.createVariable(Object.class);
        functionBytecodeCreator.assign(entityToSave, entity);
        BranchResult shouldUpdate = this.entityExists(functionBytecodeCreator, resourceClass, resource, id);
        this.updateAndReturn(shouldUpdate.trueBranch(), resourceClass, resource, id, (ResultHandle)entityToSave);
        this.createAndReturn(shouldUpdate.falseBranch(), resourceClass, resource, id, (ResultHandle)entityToSave);
        return functionCreator.getInstance();
    }

    private BranchResult entityExists(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id) {
        return creator.ifNotNull(creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceClass, (String)RESOURCE_GET_METHOD_NAME, Object.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id}));
    }

    private void createAndReturn(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id, ResultHandle entityToSave) {
        ResultHandle newEntity = creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceClass, (String)RESOURCE_UPDATE_METHOD_NAME, Object.class, (Object[])new Object[]{Object.class, Object.class}), resource, new ResultHandle[]{id, entityToSave});
        creator.returnValue(newEntity);
    }

    private void updateAndReturn(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id, ResultHandle entityToSave) {
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceClass, (String)RESOURCE_UPDATE_METHOD_NAME, Object.class, (Object[])new Object[]{Object.class, Object.class}), resource, new ResultHandle[]{id, entityToSave});
        creator.returnValue(creator.loadNull());
    }

    private ResultHandle getTransactionalExecutor(BytecodeCreator creator) {
        ResultHandle arcContainer = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instanceHandle = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), arcContainer, new ResultHandle[]{creator.loadClass(TransactionalExecutor.class), creator.newArray(Annotation.class, 0)});
        ResultHandle instance = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)RESOURCE_GET_METHOD_NAME, Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        creator.ifNull(instance).trueBranch().throwException(RuntimeException.class, TransactionalExecutor.class.getSimpleName() + " instance was not found");
        return instance;
    }
}

