/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.DataAccessImplementor;
import io.quarkus.rest.data.panache.deployment.PrivateFields;
import io.quarkus.rest.data.panache.deployment.PrivateMethods;
import io.quarkus.rest.data.panache.deployment.RestDataResourceInfo;
import io.quarkus.rest.data.panache.deployment.methods.MethodMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.MethodPropertiesAccessor;
import io.quarkus.rest.data.panache.deployment.utils.PaginationImplementor;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import javax.ws.rs.core.Response;
import org.jboss.jandex.IndexView;

public final class ListMethodImplementor
extends StandardMethodImplementor {
    public static final String NAME = "list";
    private static final String REL = "list";

    @Override
    protected void implementInternal(ClassCreator classCreator, IndexView index, MethodPropertiesAccessor propertiesAccessor, RestDataResourceInfo resourceInfo) {
        MethodMetadata methodMetadata = this.getMethodMetadata(resourceInfo);
        MethodCreator methodCreator = classCreator.getMethodCreator(methodMetadata.getName(), Response.class, new Class[0]);
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, propertiesAccessor.getPath(resourceInfo.getClassInfo(), methodMetadata));
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceInfo.getEntityClassName(), "list");
        FieldDescriptor uriInfoField = FieldDescriptor.of((String)methodCreator.getMethodDescriptor().getDeclaringClass(), (String)PrivateFields.URI_INFO.getName(), PrivateFields.URI_INFO.getType());
        MethodDescriptor isPagedMethod = MethodDescriptor.ofMethod((String)methodCreator.getMethodDescriptor().getDeclaringClass(), (String)PrivateMethods.IS_PAGED.getName(), (String)PrivateMethods.IS_PAGED.getType(), (String[])PrivateMethods.IS_PAGED.getParams());
        BranchResult isPaged = methodCreator.ifTrue(methodCreator.invokeVirtualMethod(isPagedMethod, methodCreator.getThis(), new ResultHandle[0]));
        this.returnPaged(isPaged.trueBranch(), resourceInfo.getDataAccessImplementor(), uriInfoField);
        this.returnNotPaged(isPaged.falseBranch(), resourceInfo.getDataAccessImplementor());
        methodCreator.close();
    }

    @Override
    protected MethodMetadata getMethodMetadata(RestDataResourceInfo resourceInfo) {
        return new MethodMetadata("list", new String[0]);
    }

    private void returnPaged(BytecodeCreator creator, DataAccessImplementor dataAccessImplementor, FieldDescriptor uriInfoField) {
        ResultHandle uriInfo = creator.readInstanceField(uriInfoField, creator.getThis());
        ResultHandle page = PaginationImplementor.getRequestPage(creator, uriInfo);
        ResultHandle pageCount = dataAccessImplementor.pageCount(creator, page);
        ResultHandle links = PaginationImplementor.getLinks(creator, uriInfo, page, pageCount);
        ResultHandle entities = dataAccessImplementor.findAll(creator, page);
        creator.returnValue(ResponseImplementor.ok(creator, entities, links));
    }

    private void returnNotPaged(BytecodeCreator creator, DataAccessImplementor dataAccessImplementor) {
        creator.returnValue(ResponseImplementor.ok(creator, dataAccessImplementor.listAll(creator)));
    }
}

