/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods.hal;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.PrivateFields;
import io.quarkus.rest.data.panache.deployment.PrivateMethods;
import io.quarkus.rest.data.panache.deployment.RestDataResourceInfo;
import io.quarkus.rest.data.panache.deployment.methods.MethodMetadata;
import io.quarkus.rest.data.panache.deployment.methods.hal.HalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.MethodPropertiesAccessor;
import io.quarkus.rest.data.panache.deployment.utils.PaginationImplementor;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import io.quarkus.rest.data.panache.runtime.hal.HalCollectionWrapper;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.jboss.jandex.IndexView;

public final class ListHalMethodImplementor
extends HalMethodImplementor {
    private static final String NAME = "listHal";

    @Override
    protected void implementInternal(ClassCreator classCreator, IndexView index, MethodPropertiesAccessor propertiesAccessor, RestDataResourceInfo resourceInfo) {
        MethodCreator methodCreator = classCreator.getMethodCreator(NAME, Response.class, new Class[0]);
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, propertiesAccessor.getPath(resourceInfo.getClassInfo(), this.getStandardMethodMetadata(resourceInfo)));
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        FieldDescriptor uriInfoField = FieldDescriptor.of((String)methodCreator.getMethodDescriptor().getDeclaringClass(), (String)PrivateFields.URI_INFO.getName(), PrivateFields.URI_INFO.getType());
        MethodDescriptor isPagedMethod = MethodDescriptor.ofMethod((String)methodCreator.getMethodDescriptor().getDeclaringClass(), (String)PrivateMethods.IS_PAGED.getName(), (String)PrivateMethods.IS_PAGED.getType(), (String[])PrivateMethods.IS_PAGED.getParams());
        BranchResult isPaged = methodCreator.ifTrue(methodCreator.invokeVirtualMethod(isPagedMethod, methodCreator.getThis(), new ResultHandle[0]));
        this.returnPaged(isPaged.trueBranch(), resourceInfo, uriInfoField);
        this.returnNotPaged(isPaged.falseBranch(), resourceInfo);
        methodCreator.close();
    }

    @Override
    protected MethodMetadata getStandardMethodMetadata(RestDataResourceInfo resourceInfo) {
        return new MethodMetadata("list", new String[0]);
    }

    private void returnPaged(BytecodeCreator creator, RestDataResourceInfo resourceInfo, FieldDescriptor uriInfoField) {
        ResultHandle uriInfo = creator.readInstanceField(uriInfoField, creator.getThis());
        ResultHandle page = PaginationImplementor.getRequestPage(creator, uriInfo);
        ResultHandle pageCount = resourceInfo.getDataAccessImplementor().pageCount(creator, page);
        ResultHandle links = PaginationImplementor.getLinks(creator, uriInfo, page, pageCount);
        ResultHandle entities = resourceInfo.getDataAccessImplementor().findAll(creator, page);
        ResultHandle wrapper = this.wrapHalEntities(creator, entities, resourceInfo);
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(HalCollectionWrapper.class, (String)"addLinks", Void.TYPE, (Class[])new Class[]{Link[].class}), wrapper, new ResultHandle[]{links});
        creator.returnValue(ResponseImplementor.ok(creator, wrapper, links));
    }

    private void returnNotPaged(BytecodeCreator creator, RestDataResourceInfo resourceInfo) {
        ResultHandle entities = resourceInfo.getDataAccessImplementor().listAll(creator);
        creator.returnValue(ResponseImplementor.ok(creator, this.wrapHalEntities(creator, entities, resourceInfo)));
    }
}

