/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods.hal;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.RestDataResourceInfo;
import io.quarkus.rest.data.panache.deployment.methods.MethodMetadata;
import io.quarkus.rest.data.panache.deployment.methods.hal.HalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.MethodPropertiesAccessor;
import io.quarkus.rest.data.panache.deployment.utils.FieldAccessImplementor;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import javax.ws.rs.core.Response;
import org.jboss.jandex.IndexView;

public final class UpdateHalMethodImplementor
extends HalMethodImplementor {
    private static final String NAME = "updateHal";

    @Override
    protected void implementInternal(ClassCreator classCreator, IndexView index, MethodPropertiesAccessor propertiesAccessor, RestDataResourceInfo resourceInfo) {
        MethodCreator methodCreator = classCreator.getMethodCreator(NAME, Response.class.getName(), new String[]{resourceInfo.getIdClassName(), resourceInfo.getEntityClassName()});
        this.addTransactionalAnnotation((AnnotatedElement)methodCreator);
        this.addPutAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, propertiesAccessor.getPath(resourceInfo.getClassInfo(), this.getStandardMethodMetadata(resourceInfo), "{id}"));
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        this.addConsumesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle entity = methodCreator.getMethodParam(1);
        BranchResult entityDoesNotExist = methodCreator.ifNull(resourceInfo.getDataAccessImplementor().findById((BytecodeCreator)methodCreator, id));
        FieldAccessImplementor fieldAccessImplementor = new FieldAccessImplementor(index, resourceInfo.getIdFieldPredicate());
        this.createAndReturn(entityDoesNotExist.trueBranch(), fieldAccessImplementor, resourceInfo, entity, id);
        this.updateAndReturn(entityDoesNotExist.falseBranch(), fieldAccessImplementor, resourceInfo, entity, id);
        methodCreator.close();
    }

    @Override
    protected MethodMetadata getStandardMethodMetadata(RestDataResourceInfo resourceInfo) {
        return new MethodMetadata("update", resourceInfo.getIdClassName(), resourceInfo.getEntityClassName());
    }

    private void createAndReturn(BytecodeCreator creator, FieldAccessImplementor fieldAccessImplementor, RestDataResourceInfo resourceInfo, ResultHandle entity, ResultHandle id) {
        fieldAccessImplementor.setId(creator, resourceInfo.getEntityClassName(), entity, id);
        ResultHandle newEntity = resourceInfo.getDataAccessImplementor().update(creator, entity);
        ResultHandle response = ResponseImplementor.created(creator, this.wrapHalEntity(creator, newEntity), ResponseImplementor.getEntityUrl(creator, newEntity));
        creator.returnValue(response);
    }

    private void updateAndReturn(BytecodeCreator creator, FieldAccessImplementor fieldAccessImplementor, RestDataResourceInfo resourceInfo, ResultHandle entity, ResultHandle id) {
        fieldAccessImplementor.setId(creator, resourceInfo.getEntityClassName(), entity, id);
        resourceInfo.getDataAccessImplementor().update(creator, entity);
        creator.returnValue(ResponseImplementor.noContent(creator));
    }
}

