/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.properties;

import io.quarkus.rest.data.panache.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.ResourceName;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class ResourcePropertiesAccessor {
    private static final DotName RESOURCE_PROPERTIES_ANNOTATION = DotName.createSimple((String)ResourceProperties.class.getName());
    private final IndexView index;

    public ResourcePropertiesAccessor(IndexView index) {
        this.index = index;
    }

    public boolean isHal(ClassInfo classInfo) {
        AnnotationInstance annotation = this.getAnnotation(classInfo);
        return annotation != null && annotation.value("hal") != null && annotation.value("hal").asBoolean();
    }

    public String path(ClassInfo classInfo) {
        AnnotationInstance annotation = this.getAnnotation(classInfo);
        if (annotation == null || annotation.value("path") == null || "".equals(annotation.value("path").asString())) {
            return ResourceName.fromClass(classInfo.simpleName());
        }
        return annotation.value("path").asString();
    }

    public boolean isPaged(ClassInfo classInfo) {
        AnnotationInstance annotation = this.getAnnotation(classInfo);
        return annotation == null || annotation.value("paged") == null || annotation.value("paged").asBoolean();
    }

    private AnnotationInstance getAnnotation(ClassInfo classInfo) {
        ClassInfo superControllerInterface;
        if (classInfo.classAnnotation(RESOURCE_PROPERTIES_ANNOTATION) != null) {
            return classInfo.classAnnotation(RESOURCE_PROPERTIES_ANNOTATION);
        }
        if (classInfo.superName() != null && (superControllerInterface = this.index.getClassByName(classInfo.superName())) != null) {
            return this.getAnnotation(superControllerInterface);
        }
        return null;
    }
}

