/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.utils;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ResultHandle;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class FieldAccessImplementor {
    private final IndexView index;
    private final Predicate<FieldInfo> idFieldPredicate;

    public FieldAccessImplementor(IndexView index, Predicate<FieldInfo> idFieldPredicate) {
        this.index = index;
        this.idFieldPredicate = idFieldPredicate;
    }

    public ResultHandle getId(BytecodeCreator creator, String className, ResultHandle instance) {
        ClassInfo classInfo = this.index.getClassByName(DotName.createSimple((String)className));
        FieldInfo field = this.getIdField(classInfo);
        if (field == null) {
            throw new RuntimeException(className + " does not have a field annotated with @Id");
        }
        MethodInfo getter = this.getGetter(classInfo, field);
        if (getter != null) {
            return creator.invokeVirtualMethod(getter, instance, new ResultHandle[0]);
        }
        return creator.readInstanceField(field, instance);
    }

    public void setId(BytecodeCreator creator, String className, ResultHandle instance, ResultHandle value) {
        ClassInfo classInfo = this.index.getClassByName(DotName.createSimple((String)className));
        FieldInfo field = this.getIdField(classInfo);
        if (field == null) {
            throw new RuntimeException(className + " does not have a field annotated with @Id");
        }
        MethodInfo setter = this.getSetter(classInfo, field);
        if (setter != null) {
            creator.invokeVirtualMethod(setter, instance, new ResultHandle[]{value});
        } else {
            creator.writeInstanceField(field, instance, value);
        }
    }

    private FieldInfo getIdField(ClassInfo entityClass) {
        ClassInfo superClass;
        for (FieldInfo field : entityClass.fields()) {
            if (!this.idFieldPredicate.test(field)) continue;
            return field;
        }
        if (entityClass.superName() != null && (superClass = this.index.getClassByName(entityClass.superName())) != null) {
            return this.getIdField(superClass);
        }
        return null;
    }

    private MethodInfo getGetter(ClassInfo entityClass, FieldInfo field) {
        ClassInfo superClass;
        MethodInfo getter = entityClass.method(JavaBeanUtil.getGetterName((String)field.name(), (DotName)field.type().name()), new Type[0]);
        if (getter != null) {
            return getter;
        }
        if (entityClass.superName() != null && (superClass = this.index.getClassByName(entityClass.superName())) != null) {
            this.getGetter(superClass, field);
        }
        return null;
    }

    private MethodInfo getSetter(ClassInfo entityClass, FieldInfo field) {
        ClassInfo superClass;
        MethodInfo setter = entityClass.method(JavaBeanUtil.getSetterName((String)field.name()), new Type[]{field.type()});
        if (setter != null) {
            return setter;
        }
        if (entityClass.superName() != null && (superClass = this.index.getClassByName(entityClass.superName())) != null) {
            this.getSetter(superClass, field);
        }
        return null;
    }
}

