/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.RestDataResourceInfo;
import io.quarkus.rest.data.panache.deployment.methods.MethodMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.MethodPropertiesAccessor;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import org.jboss.jandex.IndexView;

public final class DeleteMethodImplementor
extends StandardMethodImplementor {
    private static final String NAME = "delete";
    private static final String REL = "remove";

    @Override
    protected void implementInternal(ClassCreator classCreator, IndexView index, MethodPropertiesAccessor propertiesAccessor, RestDataResourceInfo resourceInfo) {
        MethodMetadata methodMetadata = this.getMethodMetadata(resourceInfo);
        MethodCreator methodCreator = classCreator.getMethodCreator(methodMetadata.getName(), Void.TYPE.getName(), methodMetadata.getParameterTypes());
        this.addTransactionalAnnotation((AnnotatedElement)methodCreator);
        this.addDeleteAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, propertiesAccessor.getPath(resourceInfo.getType(), methodMetadata, "{id}"));
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceInfo.getEntityInfo().getType(), REL);
        ResultHandle result = resourceInfo.getDataAccessImplementor().deleteById((BytecodeCreator)methodCreator, methodCreator.getMethodParam(0));
        BranchResult entityWasDeleted = methodCreator.ifNonZero(result);
        entityWasDeleted.trueBranch().returnValue(null);
        entityWasDeleted.falseBranch().throwException(ResponseImplementor.notFoundException(entityWasDeleted.falseBranch()));
        methodCreator.close();
    }

    @Override
    protected MethodMetadata getMethodMetadata(RestDataResourceInfo resourceInfo) {
        return new MethodMetadata(NAME, resourceInfo.getEntityInfo().getIdType());
    }
}

