/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods.hal;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.DataAccessImplementor;
import io.quarkus.rest.data.panache.deployment.RestDataEntityInfo;
import io.quarkus.rest.data.panache.deployment.RestDataResourceInfo;
import io.quarkus.rest.data.panache.deployment.methods.MethodMetadata;
import io.quarkus.rest.data.panache.deployment.methods.hal.HalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.MethodPropertiesAccessor;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import javax.ws.rs.core.Response;
import org.jboss.jandex.IndexView;

public final class UpdateHalMethodImplementor
extends HalMethodImplementor {
    private static final String NAME = "updateHal";

    @Override
    protected void implementInternal(ClassCreator classCreator, IndexView index, MethodPropertiesAccessor propertiesAccessor, RestDataResourceInfo resourceInfo) {
        MethodCreator methodCreator = classCreator.getMethodCreator(NAME, Response.class.getName(), new String[]{resourceInfo.getEntityInfo().getIdType(), resourceInfo.getEntityInfo().getType()});
        this.addTransactionalAnnotation((AnnotatedElement)methodCreator);
        this.addPutAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, propertiesAccessor.getPath(resourceInfo.getType(), this.getMethodMetadata(resourceInfo), "{id}"));
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        this.addConsumesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle entity = methodCreator.getMethodParam(1);
        this.setId((BytecodeCreator)methodCreator, resourceInfo.getEntityInfo(), entity, id);
        DataAccessImplementor dataAccessImplementor = resourceInfo.getDataAccessImplementor();
        BranchResult entityDoesNotExist = methodCreator.ifNull(dataAccessImplementor.findById((BytecodeCreator)methodCreator, id));
        this.createAndReturn(entityDoesNotExist.trueBranch(), dataAccessImplementor, entity);
        this.updateAndReturn(entityDoesNotExist.falseBranch(), dataAccessImplementor, entity);
        methodCreator.close();
    }

    @Override
    protected MethodMetadata getMethodMetadata(RestDataResourceInfo resourceInfo) {
        return new MethodMetadata("update", resourceInfo.getEntityInfo().getIdType(), resourceInfo.getEntityInfo().getType());
    }

    private void createAndReturn(BytecodeCreator creator, DataAccessImplementor dataAccessImplementor, ResultHandle entity) {
        ResultHandle newEntity = dataAccessImplementor.update(creator, entity);
        ResultHandle response = ResponseImplementor.created(creator, this.wrapHalEntity(creator, newEntity), ResponseImplementor.getEntityUrl(creator, newEntity));
        creator.returnValue(response);
    }

    private void updateAndReturn(BytecodeCreator creator, DataAccessImplementor dataAccessImplementor, ResultHandle entity) {
        dataAccessImplementor.update(creator, entity);
        creator.returnValue(ResponseImplementor.noContent(creator));
    }

    private void setId(BytecodeCreator creator, RestDataEntityInfo entityInfo, ResultHandle entity, ResultHandle id) {
        if (entityInfo.getIdSetter().isPresent()) {
            creator.invokeVirtualMethod(entityInfo.getIdSetter().get(), entity, new ResultHandle[]{id});
        } else {
            creator.writeInstanceField(entityInfo.getIdField(), entity, id);
        }
    }
}

