/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.utils;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.panache.common.Page;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public final class PaginationImplementor {
    public ResultHandle getRequestPage(BytecodeCreator creator, ResultHandle uriInfo) {
        ResultHandle queryParams = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(UriInfo.class, (String)"getQueryParameters", MultivaluedMap.class, (Class[])new Class[0]), uriInfo, new ResultHandle[0]);
        AssignableResultHandle page = creator.createVariable(Integer.class);
        this.assignIntQueryParam(creator, queryParams, "page", 0, 0, page);
        AssignableResultHandle size = creator.createVariable(Integer.class);
        this.assignIntQueryParam(creator, queryParams, "size", 1, 20, size);
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(Page.class, (String)"of", Page.class, (Class[])new Class[]{Integer.TYPE, Integer.TYPE}), new ResultHandle[]{page, size});
    }

    private void assignIntQueryParam(BytecodeCreator creator, ResultHandle queryParams, String key, int minValue, int defaultValue, AssignableResultHandle variable) {
        ResultHandle stringValue = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(MultivaluedMap.class, (String)"getFirst", Object.class, (Class[])new Class[]{Object.class}), queryParams, new ResultHandle[]{creator.load(key)});
        TryBlock tryBlock = creator.tryBlock();
        CatchBlockCreator catchBlockCreator = tryBlock.addCatch(NumberFormatException.class);
        catchBlockCreator.assign(variable, catchBlockCreator.load(defaultValue));
        ResultHandle value = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"parseInt", Integer.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{stringValue});
        BranchResult valueIsTooSmall = tryBlock.ifIntegerLessThan(value, tryBlock.load(minValue));
        valueIsTooSmall.trueBranch().assign(variable, tryBlock.load(defaultValue));
        valueIsTooSmall.falseBranch().assign(variable, value);
    }

    public ResultHandle getLinks(BytecodeCreator creator, ResultHandle uriInfo, ResultHandle page, ResultHandle pageCount) {
        ResultHandle links = creator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{creator.load(4)});
        ResultHandle firstPage = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Page.class, (String)"first", Page.class, (Class[])new Class[0]), page, new ResultHandle[0]);
        ResultHandle firstPageLink = this.getLink(creator, uriInfo, firstPage, "first");
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), links, new ResultHandle[]{firstPageLink});
        ResultHandle lastPage = this.getLastPage(creator, page, pageCount);
        ResultHandle lastPageLink = this.getLink(creator, uriInfo, lastPage, "last");
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), links, new ResultHandle[]{lastPageLink});
        BytecodeCreator previousPageCreator = this.isTheSamePage(creator, page, firstPage).falseBranch();
        ResultHandle previousPage = previousPageCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Page.class, (String)"previous", Page.class, (Class[])new Class[0]), page, new ResultHandle[0]);
        ResultHandle previousPageLink = this.getLink(previousPageCreator, uriInfo, previousPage, "previous");
        previousPageCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), links, new ResultHandle[]{previousPageLink});
        BytecodeCreator nextPageCreator = this.isTheSamePage(creator, page, lastPage).falseBranch();
        ResultHandle nextPage = nextPageCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Page.class, (String)"next", Page.class, (Class[])new Class[0]), page, new ResultHandle[0]);
        ResultHandle nextPageLink = this.getLink(nextPageCreator, uriInfo, nextPage, "next");
        nextPageCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), links, new ResultHandle[]{nextPageLink});
        ResultHandle linksCount = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"size", Integer.TYPE, (Class[])new Class[0]), links, new ResultHandle[0]);
        ResultHandle linksArray = creator.newArray(Link.class, linksCount);
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"toArray", Object[].class, (Class[])new Class[]{Object[].class}), links, new ResultHandle[]{linksArray});
    }

    private ResultHandle getLink(BytecodeCreator creator, ResultHandle uriInfo, ResultHandle page, String rel) {
        ResultHandle builder = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Link.class, (String)"fromUri", Link.Builder.class, (Class[])new Class[]{URI.class}), new ResultHandle[]{this.getPageUri(creator, uriInfo, page)});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Link.Builder.class, (String)"rel", Link.Builder.class, (Class[])new Class[]{String.class}), builder, new ResultHandle[]{creator.load(rel)});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Link.Builder.class, (String)"build", Link.class, (Class[])new Class[]{Object[].class}), builder, new ResultHandle[]{creator.newArray(Object.class, 0)});
    }

    private ResultHandle getPageUri(BytecodeCreator creator, ResultHandle uriInfo, ResultHandle page) {
        ResultHandle uriBuilder = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(UriInfo.class, (String)"getAbsolutePathBuilder", UriBuilder.class, (Class[])new Class[0]), uriInfo, new ResultHandle[0]);
        ResultHandle index = creator.readInstanceField(FieldDescriptor.of(Page.class, (String)"index", Integer.TYPE), page);
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(UriBuilder.class, (String)"queryParam", UriBuilder.class, (Class[])new Class[]{String.class, Object[].class}), uriBuilder, new ResultHandle[]{creator.load("page"), creator.marshalAsArray(Object.class, new ResultHandle[]{index})});
        ResultHandle size = creator.readInstanceField(FieldDescriptor.of(Page.class, (String)"size", Integer.TYPE), page);
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(UriBuilder.class, (String)"queryParam", UriBuilder.class, (Class[])new Class[]{String.class, Object[].class}), uriBuilder, new ResultHandle[]{creator.load("size"), creator.marshalAsArray(Object.class, new ResultHandle[]{size})});
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(UriBuilder.class, (String)"build", URI.class, (Class[])new Class[]{Object[].class}), uriBuilder, new ResultHandle[]{creator.newArray(Object.class, 0)});
    }

    private ResultHandle getLastPage(BytecodeCreator creator, ResultHandle page, ResultHandle pageCount) {
        ResultHandle pageNumber = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"sum", Integer.TYPE, (Class[])new Class[]{Integer.TYPE, Integer.TYPE}), new ResultHandle[]{pageCount, creator.load(-1)});
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Page.class, (String)"index", Page.class, (Class[])new Class[]{Integer.TYPE}), page, new ResultHandle[]{pageNumber});
    }

    private BranchResult isTheSamePage(BytecodeCreator creator, ResultHandle page, ResultHandle anotherPage) {
        ResultHandle index = creator.readInstanceField(FieldDescriptor.of(Page.class, (String)"index", Integer.TYPE), page);
        ResultHandle anotherIndex = creator.readInstanceField(FieldDescriptor.of(Page.class, (String)"index", Integer.TYPE), anotherPage);
        return creator.ifIntegerEqual(index, anotherIndex);
    }
}

