/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.utils;

import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.panache.common.Sort;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public final class SortImplementor {
    public ResultHandle getSort(BytecodeCreator creator, ResultHandle uriInfo) {
        ResultHandle sort = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Sort.class, (String)"by", Sort.class, (Class[])new Class[]{String[].class}), new ResultHandle[]{creator.newArray(String.class, 0)});
        ResultHandle fieldsIterator = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), this.getSortFields(creator, uriInfo), new ResultHandle[0]);
        BytecodeCreator loopCreator = creator.whileLoop(c -> this.iteratorHasNext((BytecodeCreator)c, fieldsIterator)).block();
        ResultHandle field = loopCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), fieldsIterator, new ResultHandle[0]);
        BranchResult isDescendingBranch = this.isDescendingField(loopCreator, field);
        this.addDescendingSortField(isDescendingBranch.trueBranch(), sort, field);
        this.addAscendingSortField(isDescendingBranch.falseBranch(), sort, field);
        return sort;
    }

    private void addAscendingSortField(BytecodeCreator creator, ResultHandle sort, ResultHandle field) {
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Sort.class, (String)"and", Sort.class, (Class[])new Class[]{String.class}), sort, new ResultHandle[]{field});
    }

    private void addDescendingSortField(BytecodeCreator creator, ResultHandle sort, ResultHandle field) {
        ResultHandle fieldToAdd = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(String.class, (String)"substring", String.class, (Class[])new Class[]{Integer.TYPE}), field, new ResultHandle[]{creator.load(1)});
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Sort.class, (String)"and", Sort.class, (Class[])new Class[]{String.class, Sort.Direction.class}), sort, new ResultHandle[]{fieldToAdd, creator.load((Enum)Sort.Direction.Descending)});
    }

    private BranchResult isDescendingField(BytecodeCreator creator, ResultHandle field) {
        return creator.ifTrue(creator.invokeVirtualMethod(MethodDescriptor.ofMethod(String.class, (String)"startsWith", Boolean.TYPE, (Class[])new Class[]{String.class}), field, new ResultHandle[]{creator.load("-")}));
    }

    private ResultHandle getSortFields(BytecodeCreator creator, ResultHandle uriInfo) {
        ResultHandle sortFieldsList = creator.newInstance(MethodDescriptor.ofConstructor(LinkedList.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle sortParamsIterator = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), this.getSortQueryParams(creator, uriInfo), new ResultHandle[0]);
        BytecodeCreator loopCreator = creator.whileLoop(c -> this.iteratorHasNext((BytecodeCreator)c, sortParamsIterator)).block();
        ResultHandle sortParam = loopCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), sortParamsIterator, new ResultHandle[0]);
        ResultHandle extractedSortFields = this.extractSortFieldsFromParam(loopCreator, sortParam);
        loopCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"addAll", Boolean.TYPE, (Class[])new Class[]{Collection.class}), sortFieldsList, new ResultHandle[]{extractedSortFields});
        return sortFieldsList;
    }

    private ResultHandle getSortQueryParams(BytecodeCreator creator, ResultHandle uriInfo) {
        ResultHandle queryParams = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(UriInfo.class, (String)"getQueryParameters", MultivaluedMap.class, (Class[])new Class[0]), uriInfo, new ResultHandle[0]);
        ResultHandle emptyList = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyList", List.class, (Class[])new Class[0]), new ResultHandle[0]);
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(MultivaluedMap.class, (String)"getOrDefault", Object.class, (Class[])new Class[]{Object.class, Object.class}), queryParams, new ResultHandle[]{creator.load("sort"), emptyList});
    }

    private ResultHandle extractSortFieldsFromParam(BytecodeCreator creator, ResultHandle sortParam) {
        ResultHandle sortFieldsArray = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(String.class, (String)"split", String[].class, (Class[])new Class[]{String.class}), sortParam, new ResultHandle[]{creator.load(",")});
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(Arrays.class, (String)"asList", List.class, (Class[])new Class[]{Object[].class}), new ResultHandle[]{sortFieldsArray});
    }

    private BranchResult iteratorHasNext(BytecodeCreator creator, ResultHandle iterator) {
        return creator.ifTrue(creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]));
    }
}

