/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.rest.data.panache.deployment.JaxRsResourceImplementor;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.RestDataResourceBuildItem;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.properties.ResourcePropertiesBuildItem;
import io.quarkus.rest.data.panache.deployment.properties.ResourcePropertiesProvider;
import io.quarkus.rest.data.panache.runtime.sort.SortQueryParamFilter;
import io.quarkus.rest.data.panache.runtime.sort.SortQueryParamValidator;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerRequestFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.GeneratedJaxRsResourceBuildItem;
import io.quarkus.resteasy.reactive.spi.GeneratedJaxRsResourceGizmoAdaptor;
import java.util.Collections;
import java.util.List;

public class RestDataProcessor {
    @BuildStep
    void supportingBuildItems(Capabilities capabilities, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItemBuildProducer, BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviderBuildItemBuildProducer, BuildProducer<ContainerRequestFilterBuildItem> containerRequestFilterBuildItemBuildProducer) {
        boolean isResteasyClassicAvailable = capabilities.isPresent("io.quarkus.resteasy");
        boolean isResteasyReactiveAvailable = capabilities.isPresent("io.quarkus.resteasy.reactive");
        if (!isResteasyClassicAvailable && !isResteasyReactiveAvailable) {
            throw new IllegalStateException("REST Data Panache can only work if 'quarkus-resteasy' or 'quarkus-resteasy-reactive' is present");
        }
        if (isResteasyClassicAvailable) {
            runtimeInitializedClassBuildItemBuildProducer.produce((BuildItem)new RuntimeInitializedClassBuildItem("org.jboss.resteasy.links.impl.EL"));
            resteasyJaxrsProviderBuildItemBuildProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(SortQueryParamFilter.class.getName()));
        } else {
            containerRequestFilterBuildItemBuildProducer.produce((BuildItem)((ContainerRequestFilterBuildItem.Builder)new ContainerRequestFilterBuildItem.Builder(SortQueryParamFilter.class.getName()).setNameBindingNames(Collections.singleton(SortQueryParamValidator.class.getName()))).build());
        }
    }

    @BuildStep
    void implementResources(CombinedIndexBuildItem index, List<RestDataResourceBuildItem> resourceBuildItems, List<ResourcePropertiesBuildItem> resourcePropertiesBuildItems, Capabilities capabilities, BuildProducer<GeneratedBeanBuildItem> resteasyClassicImplementationsProducer, BuildProducer<GeneratedJaxRsResourceBuildItem> resteasyReactiveImplementationsProducer) {
        boolean isReactivePanache = capabilities.isPresent("io.quarkus.hibernate.reactive");
        boolean isResteasyClassic = capabilities.isPresent("io.quarkus.resteasy");
        if (isReactivePanache && isResteasyClassic) {
            throw new IllegalStateException("Reactive REST Data Panache does not work with 'quarkus-resteasy'. Only 'quarkus-resteasy-reactive' extensions are supported");
        }
        GeneratedBeanGizmoAdaptor classOutput = isResteasyClassic ? new GeneratedBeanGizmoAdaptor(resteasyClassicImplementationsProducer) : new GeneratedJaxRsResourceGizmoAdaptor(resteasyReactiveImplementationsProducer);
        JaxRsResourceImplementor jaxRsResourceImplementor = new JaxRsResourceImplementor(this.hasValidatorCapability(capabilities), isResteasyClassic, isReactivePanache);
        ResourcePropertiesProvider resourcePropertiesProvider = new ResourcePropertiesProvider(index.getIndex());
        for (RestDataResourceBuildItem resourceBuildItem : resourceBuildItems) {
            ResourceMetadata resourceMetadata = resourceBuildItem.getResourceMetadata();
            ResourceProperties resourceProperties = this.getResourceProperties(resourcePropertiesProvider, resourceMetadata, resourcePropertiesBuildItems);
            if (resourceProperties.isHal()) {
                if (isResteasyClassic && !this.hasAnyJsonCapabilityForResteasyClassic(capabilities)) {
                    throw new IllegalStateException("Cannot generate HAL endpoints without either 'quarkus-resteasy-jsonb' or 'quarkus-resteasy-jackson'");
                }
                if (!isResteasyClassic && !this.hasAnyJsonCapabilityForResteasyReactive(capabilities)) {
                    throw new IllegalStateException("Cannot generate HAL endpoints without either 'quarkus-resteasy-reactive-jsonb' or 'quarkus-resteasy-reactive-jackson'");
                }
            }
            if (!resourceProperties.isExposed()) continue;
            jaxRsResourceImplementor.implement((ClassOutput)classOutput, resourceMetadata, resourceProperties, capabilities);
        }
    }

    private ResourceProperties getResourceProperties(ResourcePropertiesProvider resourcePropertiesProvider, ResourceMetadata resourceMetadata, List<ResourcePropertiesBuildItem> resourcePropertiesBuildItems) {
        for (ResourcePropertiesBuildItem resourcePropertiesBuildItem : resourcePropertiesBuildItems) {
            if (!resourcePropertiesBuildItem.getResourceType().equals(resourceMetadata.getResourceClass()) && !resourcePropertiesBuildItem.getResourceType().equals(resourceMetadata.getResourceInterface())) continue;
            return resourcePropertiesBuildItem.getResourcePropertiesInfo();
        }
        return resourcePropertiesProvider.getForInterface(resourceMetadata.getResourceInterface());
    }

    private boolean hasValidatorCapability(Capabilities capabilities) {
        return capabilities.isPresent("io.quarkus.hibernate.validator");
    }

    private boolean hasAnyJsonCapabilityForResteasyClassic(Capabilities capabilities) {
        return capabilities.isPresent("io.quarkus.resteasy.json.jsonb") || capabilities.isPresent("io.quarkus.resteasy.json.jackson");
    }

    private boolean hasAnyJsonCapabilityForResteasyReactive(Capabilities capabilities) {
        return capabilities.isPresent("io.quarkus.resteasy.reactive.json.jsonb") || capabilities.isPresent("io.quarkus.resteasy.reactive.json.jackson");
    }
}

