/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.AddMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.DeleteMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.GetMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.ListMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.MethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.UpdateMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.hal.ListHalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.runtime.util.HashUtil;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Path;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

class JaxRsResourceImplementor {
    private static final Logger LOGGER = Logger.getLogger(JaxRsResourceImplementor.class);
    private static final String OPENAPI_TAG_ANNOTATION = "org.eclipse.microprofile.openapi.annotations.tags.Tag";
    private final List<MethodImplementor> methodImplementors;

    JaxRsResourceImplementor(boolean withValidation, boolean isResteasyClassic, boolean isReactivePanache) {
        this.methodImplementors = Arrays.asList(new GetMethodImplementor(isResteasyClassic, isReactivePanache), new ListMethodImplementor(isResteasyClassic, isReactivePanache), new AddMethodImplementor(withValidation, isResteasyClassic, isReactivePanache), new UpdateMethodImplementor(withValidation, isResteasyClassic, isReactivePanache), new DeleteMethodImplementor(isResteasyClassic, isReactivePanache), new ListHalMethodImplementor(isResteasyClassic, isReactivePanache));
    }

    void implement(ClassOutput classOutput, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, Capabilities capabilities) {
        String controllerClassName = resourceMetadata.getResourceInterface() + "JaxRs_" + HashUtil.sha1((String)resourceMetadata.getResourceInterface());
        LOGGER.tracef("Starting generation of '%s'", (Object)controllerClassName);
        ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(controllerClassName).build();
        this.implementClassAnnotations(classCreator, resourceMetadata, resourceProperties, capabilities);
        FieldDescriptor resourceField = this.implementResourceField(classCreator, resourceMetadata);
        this.implementMethods(classCreator, resourceMetadata, resourceProperties, resourceField);
        classCreator.close();
        LOGGER.tracef("Completed generation of '%s'", (Object)controllerClassName);
    }

    private void implementClassAnnotations(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, Capabilities capabilities) {
        classCreator.addAnnotation(Path.class).addValue("value", (Object)resourceProperties.getPath());
        if (capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            String className = StringUtils.substringAfterLast((String)resourceMetadata.getResourceInterface(), (String)".");
            classCreator.addAnnotation(OPENAPI_TAG_ANNOTATION).add("name", (Object)className);
        }
    }

    private FieldDescriptor implementResourceField(ClassCreator classCreator, ResourceMetadata resourceMetadata) {
        FieldCreator resourceFieldCreator = classCreator.getFieldCreator("resource", resourceMetadata.getResourceClass());
        ((FieldCreator)resourceFieldCreator.setModifiers(resourceFieldCreator.getModifiers() & 0xFFFFFFFD)).addAnnotation(Inject.class);
        return resourceFieldCreator.getFieldDescriptor();
    }

    private void implementMethods(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        for (MethodImplementor methodImplementor : this.methodImplementors) {
            methodImplementor.implement(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }
}

