/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.AnnotationCreator;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.RestDataPanacheException;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.MethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import io.quarkus.rest.data.panache.runtime.sort.SortQueryParamValidator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.jboss.logging.Logger;

public abstract class StandardMethodImplementor
implements MethodImplementor {
    private static final Logger LOGGER = Logger.getLogger(StandardMethodImplementor.class);
    protected final ResponseImplementor responseImplementor;
    private final boolean isResteasyClassic;
    private final boolean isReactivePanache;

    protected StandardMethodImplementor(boolean isResteasyClassic, boolean isReactivePanache) {
        this.isResteasyClassic = isResteasyClassic;
        this.isReactivePanache = isReactivePanache;
        this.responseImplementor = new ResponseImplementor(isResteasyClassic);
    }

    @Override
    public void implement(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        if (resourceProperties.isExposed(this.getResourceMethodName())) {
            this.implementInternal(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }

    protected abstract void implementInternal(ClassCreator var1, ResourceMetadata var2, ResourceProperties var3, FieldDescriptor var4);

    protected abstract String getResourceMethodName();

    protected TryBlock implementTryBlock(BytecodeCreator bytecodeCreator, String message) {
        TryBlock tryBlock = bytecodeCreator.tryBlock();
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        catchBlock.throwException(RestDataPanacheException.class, message, catchBlock.getCaughtException());
        catchBlock.close();
        return tryBlock;
    }

    protected void addGetAnnotation(AnnotatedElement element) {
        element.addAnnotation(GET.class);
    }

    protected void addPostAnnotation(AnnotatedElement element) {
        element.addAnnotation(POST.class);
    }

    protected void addPutAnnotation(AnnotatedElement element) {
        element.addAnnotation(PUT.class);
    }

    protected void addDeleteAnnotation(AnnotatedElement element) {
        element.addAnnotation(DELETE.class);
    }

    protected void addLinksAnnotation(AnnotatedElement element, String entityClassName, String rel) {
        if (this.isResteasyClassic) {
            AnnotationCreator linkResource = element.addAnnotation("org.jboss.resteasy.links.LinkResource");
            linkResource.addValue("entityClassName", (Object)entityClassName);
            linkResource.addValue("rel", (Object)rel);
        } else {
            AnnotationCreator linkResource = element.addAnnotation("io.quarkus.resteasy.reactive.links.RestLink");
            try {
                Class<?> entityClass = Thread.currentThread().getContextClassLoader().loadClass(entityClassName);
                linkResource.addValue("entityType", entityClass);
                linkResource.addValue("rel", (Object)rel);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)("Unable to create links for entity: '" + entityClassName + "'"), (Throwable)e);
            }
        }
    }

    protected void addPathAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(Path.class).addValue("value", (Object)value);
    }

    protected void addPathParamAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(PathParam.class).addValue("value", (Object)value);
    }

    protected void addQueryParamAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(QueryParam.class).addValue("value", (Object)value);
    }

    protected void addDefaultValueAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(DefaultValue.class).addValue("value", (Object)value);
    }

    protected void addProducesJsonAnnotation(AnnotatedElement element, ResourceProperties properties) {
        if (properties.isHal()) {
            this.addProducesAnnotation(element, "application/json", "application/hal+json");
        } else {
            this.addProducesAnnotation(element, "application/json");
        }
    }

    protected void addProducesAnnotation(AnnotatedElement element, String ... mediaTypes) {
        element.addAnnotation(Produces.class).addValue("value", (Object)mediaTypes);
    }

    protected void addConsumesAnnotation(AnnotatedElement element, String ... mediaTypes) {
        element.addAnnotation(Consumes.class).addValue("value", (Object)mediaTypes);
    }

    protected void addContextAnnotation(AnnotatedElement element) {
        element.addAnnotation(Context.class);
    }

    protected void addSortQueryParamValidatorAnnotation(AnnotatedElement element) {
        element.addAnnotation(SortQueryParamValidator.class);
    }

    protected String appendToPath(String path, String suffix) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        if (suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        return String.join((CharSequence)"/", path, suffix);
    }

    protected boolean isResteasyClassic() {
        return this.isResteasyClassic;
    }

    protected boolean isNotReactivePanache() {
        return !this.isReactivePanache;
    }
}

