/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.utils;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.MethodCreator;

public final class SignatureMethodCreator {
    public static MethodCreator getMethodCreator(String methodName, ClassCreator classCreator, ReturnType returnType, Object ... parameters) {
        MethodCreator methodCreator = classCreator.getMethodCreator(methodName, returnType.type, parameters);
        StringBuilder signatureBuilder = new StringBuilder();
        signatureBuilder.append("(");
        SignatureMethodCreator.parametersToSignature(signatureBuilder, parameters);
        signatureBuilder.append(")");
        signatureBuilder.append(SignatureMethodCreator.stringToSignature(returnType.type.getName()));
        if (returnType.parameterTypes.length > 0) {
            signatureBuilder.append("<");
            SignatureMethodCreator.parametersToSignature(signatureBuilder, returnType.parameterTypes);
            signatureBuilder.append(">");
        }
        signatureBuilder.append(";");
        methodCreator.setSignature(signatureBuilder.toString());
        return methodCreator;
    }

    private static void parametersToSignature(StringBuilder signatureBuilder, Object[] parameters) {
        for (Object parameter : parameters) {
            if (parameter instanceof Class) {
                signatureBuilder.append(DescriptorUtils.classToStringRepresentation((Class)((Class)parameter)));
                continue;
            }
            if (!(parameter instanceof String)) continue;
            signatureBuilder.append(SignatureMethodCreator.stringToSignature((String)parameter) + ";");
        }
    }

    private static String stringToSignature(String className) {
        return "L" + className.replace('.', '/');
    }

    public static ReturnType ofType(Class<?> type, Object ... parameterTypes) {
        ReturnType returnType = new ReturnType();
        returnType.type = type;
        returnType.parameterTypes = parameterTypes;
        return returnType;
    }

    public static class ReturnType {
        private Class<?> type;
        private Object[] parameterTypes;
    }
}

