/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.SignatureMethodCreator;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import io.smallrye.mutiny.Uni;
import javax.validation.Valid;
import javax.ws.rs.core.Response;

public final class AddMethodImplementor
extends StandardMethodImplementor {
    private static final String METHOD_NAME = "add";
    private static final String RESOURCE_METHOD_NAME = "add";
    private static final String EXCEPTION_MESSAGE = "Failed to add an entity";
    private static final String REL = "add";

    public AddMethodImplementor(Capabilities capabilities) {
        super(capabilities);
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator("add", classCreator, this.isNotReactivePanache() ? SignatureMethodCreator.ofType(Response.class, new Object[0]) : SignatureMethodCreator.ofType(Uni.class, resourceMetadata.getEntityType()), resourceMetadata.getEntityType());
        this.addPathAnnotation((AnnotatedElement)methodCreator, resourceProperties.getPath("add"));
        this.addPostAnnotation((AnnotatedElement)methodCreator);
        this.addConsumesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addProducesJsonAnnotation((AnnotatedElement)methodCreator, resourceProperties);
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceMetadata.getEntityType(), "add");
        this.addOpenApiResponseAnnotation((AnnotatedElement)methodCreator, Response.Status.CREATED, resourceMetadata.getEntityType());
        this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
        if (this.hasValidatorCapability()) {
            methodCreator.getParameterAnnotations(0).addAnnotation(Valid.class);
        }
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle entityToSave = methodCreator.getMethodParam(0);
        if (this.isNotReactivePanache()) {
            TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, EXCEPTION_MESSAGE);
            ResultHandle entity = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"add", Object.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{entityToSave});
            tryBlock.returnValue(this.responseImplementor.created((BytecodeCreator)tryBlock, entity));
            tryBlock.close();
        } else {
            ResultHandle uniEntity = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"add", Uni.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{entityToSave});
            methodCreator.returnValue(UniImplementor.map((BytecodeCreator)methodCreator, uniEntity, EXCEPTION_MESSAGE, (body, item) -> body.returnValue(this.responseImplementor.created((BytecodeCreator)body, (ResultHandle)item))));
        }
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return "add";
    }
}

