/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.SignatureMethodCreator;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import io.smallrye.mutiny.Uni;
import javax.ws.rs.core.Response;

public final class DeleteMethodImplementor
extends StandardMethodImplementor {
    private static final String METHOD_NAME = "delete";
    private static final String RESOURCE_METHOD_NAME = "delete";
    private static final String EXCEPTION_MESSAGE = "Failed to delete an entity";
    private static final String REL = "remove";

    public DeleteMethodImplementor(Capabilities capabilities) {
        super(capabilities);
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator("delete", classCreator, this.isNotReactivePanache() ? SignatureMethodCreator.ofType(Response.class, new Object[0]) : SignatureMethodCreator.ofType(Uni.class, resourceMetadata.getEntityType()), resourceMetadata.getIdType());
        this.addPathAnnotation((AnnotatedElement)methodCreator, this.appendToPath(resourceProperties.getPath("delete"), "{id}"));
        this.addDeleteAnnotation((AnnotatedElement)methodCreator);
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceMetadata.getEntityType(), REL);
        this.addOpenApiResponseAnnotation((AnnotatedElement)methodCreator, Response.Status.NO_CONTENT);
        this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle id = methodCreator.getMethodParam(0);
        if (this.isNotReactivePanache()) {
            TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, EXCEPTION_MESSAGE);
            ResultHandle deleted = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"delete", Boolean.TYPE, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id});
            BranchResult entityWasDeleted = tryBlock.ifNonZero(deleted);
            entityWasDeleted.trueBranch().returnValue(this.responseImplementor.noContent(entityWasDeleted.trueBranch()));
            entityWasDeleted.falseBranch().returnValue(this.responseImplementor.notFound(entityWasDeleted.falseBranch()));
            tryBlock.close();
        } else {
            ResultHandle uniDeleted = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"delete", Uni.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id});
            methodCreator.returnValue(UniImplementor.map((BytecodeCreator)methodCreator, uniDeleted, EXCEPTION_MESSAGE, (body, entity) -> {
                ResultHandle deleted = body.checkCast(entity, Boolean.class);
                ResultHandle falseDefault = body.invokeStaticMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"valueOf", Boolean.class, (Class[])new Class[]{String.class}), new ResultHandle[]{body.load("false")});
                ResultHandle deletedAsInt = body.invokeVirtualMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"compareTo", Integer.TYPE, (Class[])new Class[]{Boolean.class}), deleted, new ResultHandle[]{falseDefault});
                BranchResult entityWasDeleted = body.ifNonZero(deletedAsInt);
                entityWasDeleted.trueBranch().returnValue(this.responseImplementor.noContent(entityWasDeleted.trueBranch()));
                entityWasDeleted.falseBranch().returnValue(this.responseImplementor.notFound(entityWasDeleted.falseBranch()));
            }));
        }
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return "delete";
    }
}

