/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods.hal;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.hal.HalCollectionWrapper;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.hal.HalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.PaginationImplementor;
import io.quarkus.rest.data.panache.deployment.utils.SignatureMethodCreator;
import io.quarkus.rest.data.panache.deployment.utils.SortImplementor;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import io.smallrye.mutiny.Uni;
import java.util.List;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public final class ListHalMethodImplementor
extends HalMethodImplementor {
    private static final String METHOD_NAME = "listHal";
    private static final String RESOURCE_METHOD_NAME = "list";
    private static final String EXCEPTION_MESSAGE = "Failed to list the entities";
    private final PaginationImplementor paginationImplementor;
    private final SortImplementor sortImplementor = new SortImplementor();

    public ListHalMethodImplementor(Capabilities capabilities) {
        super(capabilities);
        this.paginationImplementor = new PaginationImplementor();
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        if (resourceProperties.isPaged()) {
            this.implementPaged(classCreator, resourceMetadata, resourceProperties, resourceField);
        } else {
            this.implementNotPaged(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }

    @Override
    protected String getResourceMethodName() {
        return RESOURCE_METHOD_NAME;
    }

    private void implementPaged(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator(METHOD_NAME, classCreator, this.isNotReactivePanache() ? SignatureMethodCreator.ofType(Response.class, new Object[0]) : SignatureMethodCreator.ofType(Uni.class, resourceMetadata.getEntityType()), List.class, Integer.TYPE, Integer.TYPE, UriInfo.class);
        this.addPathAnnotation((AnnotatedElement)methodCreator, resourceProperties.getPath(RESOURCE_METHOD_NAME));
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
        this.addSortQueryParamValidatorAnnotation((AnnotatedElement)methodCreator);
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(0), "sort");
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(1), "page");
        this.addDefaultValueAnnotation(methodCreator.getParameterAnnotations(1), Integer.toString(0));
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(2), "size");
        this.addDefaultValueAnnotation(methodCreator.getParameterAnnotations(2), Integer.toString(20));
        this.addContextAnnotation(methodCreator.getParameterAnnotations(3));
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle sortQuery = methodCreator.getMethodParam(0);
        ResultHandle sort = this.sortImplementor.getSort((BytecodeCreator)methodCreator, sortQuery);
        ResultHandle pageIndex = methodCreator.getMethodParam(1);
        ResultHandle pageSize = methodCreator.getMethodParam(2);
        ResultHandle page = this.paginationImplementor.getPage((BytecodeCreator)methodCreator, pageIndex, pageSize);
        ResultHandle uriInfo = methodCreator.getMethodParam(3);
        if (this.isNotReactivePanache()) {
            TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, EXCEPTION_MESSAGE);
            ResultHandle pageCount2 = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"$$_page_count_list", Integer.TYPE, (Object[])new Object[]{Page.class}), resource, new ResultHandle[]{page});
            ResultHandle links = this.paginationImplementor.getLinks((BytecodeCreator)tryBlock, uriInfo, page, pageCount2);
            ResultHandle entities = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)RESOURCE_METHOD_NAME, List.class, (Object[])new Object[]{Page.class, Sort.class}), resource, new ResultHandle[]{page, sort});
            this.returnWrappedHalEntitiesWithLinks((BytecodeCreator)tryBlock, resourceMetadata, resourceProperties, entities, links);
            tryBlock.close();
        } else {
            ResultHandle uniPageCount = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"$$_page_count_list", Uni.class, (Object[])new Object[]{Page.class}), resource, new ResultHandle[]{page});
            methodCreator.returnValue(UniImplementor.flatMap((BytecodeCreator)methodCreator, uniPageCount, EXCEPTION_MESSAGE, (pageCountBody, pageCount) -> {
                ResultHandle links = this.paginationImplementor.getLinks((BytecodeCreator)pageCountBody, uriInfo, page, (ResultHandle)pageCount);
                ResultHandle uniEntities = pageCountBody.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)RESOURCE_METHOD_NAME, Uni.class, (Object[])new Object[]{Page.class, Sort.class}), resource, new ResultHandle[]{page, sort});
                pageCountBody.returnValue(UniImplementor.map(pageCountBody, uniEntities, EXCEPTION_MESSAGE, (entitiesBody, entities) -> this.returnWrappedHalEntitiesWithLinks((BytecodeCreator)entitiesBody, resourceMetadata, resourceProperties, (ResultHandle)entities, links)));
            }));
        }
        methodCreator.close();
    }

    private void returnWrappedHalEntitiesWithLinks(BytecodeCreator body, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, ResultHandle entities, ResultHandle links) {
        ResultHandle wrapper = this.wrapHalEntities(body, entities, resourceMetadata.getEntityType(), resourceProperties.getHalCollectionName());
        body.invokeVirtualMethod(MethodDescriptor.ofMethod(HalCollectionWrapper.class, (String)"addLinks", Void.TYPE, (Class[])new Class[]{Link[].class}), wrapper, new ResultHandle[]{links});
        body.returnValue(this.responseImplementor.ok(body, wrapper, links));
    }

    private void implementNotPaged(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceFieldDescriptor) {
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator(METHOD_NAME, classCreator, this.isNotReactivePanache() ? SignatureMethodCreator.ofType(Response.class, new Object[0]) : SignatureMethodCreator.ofType(Uni.class, resourceMetadata.getEntityType()), List.class);
        this.addPathAnnotation((AnnotatedElement)methodCreator, resourceProperties.getPath(RESOURCE_METHOD_NAME));
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(0), "sort");
        ResultHandle sortQuery = methodCreator.getMethodParam(0);
        ResultHandle sort = this.sortImplementor.getSort((BytecodeCreator)methodCreator, sortQuery);
        ResultHandle resource = methodCreator.readInstanceField(resourceFieldDescriptor, methodCreator.getThis());
        if (this.isNotReactivePanache()) {
            TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, EXCEPTION_MESSAGE);
            ResultHandle entities2 = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)RESOURCE_METHOD_NAME, List.class, (Object[])new Object[]{Page.class, Sort.class}), resource, new ResultHandle[]{tryBlock.loadNull(), sort});
            this.returnWrappedHalEntities((BytecodeCreator)tryBlock, resourceMetadata, resourceProperties, entities2);
            tryBlock.close();
        } else {
            ResultHandle uniEntities = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)RESOURCE_METHOD_NAME, Uni.class, (Object[])new Object[]{Page.class, Sort.class}), resource, new ResultHandle[]{methodCreator.loadNull(), sort});
            methodCreator.returnValue(UniImplementor.map((BytecodeCreator)methodCreator, uniEntities, EXCEPTION_MESSAGE, (body, entities) -> this.returnWrappedHalEntities((BytecodeCreator)body, resourceMetadata, resourceProperties, (ResultHandle)entities)));
        }
        methodCreator.close();
    }

    private void returnWrappedHalEntities(BytecodeCreator body, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, ResultHandle entities) {
        ResultHandle wrapper = this.wrapHalEntities(body, entities, resourceMetadata.getEntityType(), resourceProperties.getHalCollectionName());
        body.returnValue(this.responseImplementor.ok(body, wrapper));
    }
}

