/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public class ResourceMethodListenerImplementor {
    private static final String ON_AFTER = "onAfter";
    private static final String ON_BEFORE_ADD_METHOD_NAME = "onBeforeAdd";
    private static final String ON_AFTER_ADD_METHOD_NAME = "onAfterAdd";
    private static final String ON_BEFORE_UPDATE_METHOD_NAME = "onBeforeUpdate";
    private static final String ON_AFTER_UPDATE_METHOD_NAME = "onAfterUpdate";
    private static final String ON_BEFORE_DELETE_METHOD_NAME = "onBeforeDelete";
    private static final String ON_AFTER_DELETE_METHOD_NAME = "onAfterDelete";
    private final Map<FieldDescriptor, ClassInfo> listenerFields = new HashMap<FieldDescriptor, ClassInfo>();
    private final boolean isHibernateReactive;

    public ResourceMethodListenerImplementor(ClassCreator cc, List<ClassInfo> resourceMethodListeners, boolean isHibernateReactive) {
        this.isHibernateReactive = isHibernateReactive;
        for (int index = 0; index < resourceMethodListeners.size(); ++index) {
            ClassInfo eventListenerClass = resourceMethodListeners.get(index);
            FieldCreator delegateField = (FieldCreator)cc.getFieldCreator("listener" + index, eventListenerClass.name().toString()).setModifiers(4);
            delegateField.addAnnotation(Inject.class);
            this.listenerFields.put(delegateField.getFieldDescriptor(), eventListenerClass);
        }
    }

    public void onBeforeAdd(BytecodeCreator methodCreator, ResultHandle entity) {
        this.invokeMethodUsingEntity(ON_BEFORE_ADD_METHOD_NAME, methodCreator, entity);
    }

    public void onAfterAdd(BytecodeCreator methodCreator, ResultHandle entity) {
        this.invokeMethodUsingEntity(ON_AFTER_ADD_METHOD_NAME, methodCreator, entity);
    }

    public void onBeforeUpdate(BytecodeCreator methodCreator, ResultHandle entity) {
        this.invokeMethodUsingEntity(ON_BEFORE_UPDATE_METHOD_NAME, methodCreator, entity);
    }

    public void onAfterUpdate(BytecodeCreator methodCreator, ResultHandle entity) {
        this.invokeMethodUsingEntity(ON_AFTER_UPDATE_METHOD_NAME, methodCreator, entity);
    }

    public void onBeforeDelete(BytecodeCreator methodCreator, ResultHandle id) {
        this.invokeMethodUsingId(ON_BEFORE_DELETE_METHOD_NAME, methodCreator, id);
    }

    public void onAfterDelete(BytecodeCreator methodCreator, ResultHandle id) {
        this.invokeMethodUsingId(ON_AFTER_DELETE_METHOD_NAME, methodCreator, id);
    }

    private void invokeMethodUsingEntity(String methodName, BytecodeCreator methodCreator, ResultHandle entity) {
        this.processEventListener(methodName, methodCreator, (eventListener, method) -> {
            if (this.isUsingHibernateReactiveAndOnAfterMethod(methodName)) {
                UniImplementor.subscribeWith(methodCreator, entity, (lambda, item) -> {
                    lambda.invokeVirtualMethod(method, eventListener, new ResultHandle[]{item});
                    lambda.returnNull();
                });
            } else {
                methodCreator.invokeVirtualMethod(method, eventListener, new ResultHandle[]{entity});
            }
        });
    }

    private void invokeMethodUsingId(String methodName, BytecodeCreator methodCreator, ResultHandle id) {
        this.processEventListener(methodName, methodCreator, (eventListener, method) -> methodCreator.invokeVirtualMethod(method, eventListener, new ResultHandle[]{id}));
    }

    private boolean isUsingHibernateReactiveAndOnAfterMethod(String methodName) {
        return this.isHibernateReactive && methodName.startsWith(ON_AFTER);
    }

    private void processEventListener(String methodName, BytecodeCreator methodCreator, BiConsumer<ResultHandle, MethodInfo> apply) {
        for (Map.Entry<FieldDescriptor, ClassInfo> eventListenerEntry : this.listenerFields.entrySet()) {
            MethodInfo method = this.findMethodByName(eventListenerEntry.getValue(), methodName);
            if (method == null) continue;
            ResultHandle eventListener = methodCreator.readInstanceField(eventListenerEntry.getKey(), methodCreator.getThis());
            apply.accept(eventListener, method);
        }
    }

    private MethodInfo findMethodByName(ClassInfo classInfo, String methodName) {
        List methods = classInfo.methods();
        for (int index = 0; index < methods.size(); ++index) {
            MethodInfo method = (MethodInfo)methods.get(index);
            if (!methodName.equals(method.name())) continue;
            return method;
        }
        return null;
    }
}

