/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.utils;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hal.HalService;
import io.quarkus.resteasy.links.runtime.hal.ResteasyHalService;
import io.quarkus.resteasy.reactive.links.runtime.hal.ResteasyReactiveHalService;
import java.lang.annotation.Annotation;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;

public final class ResponseImplementor {
    private final Capabilities capabilities;

    public ResponseImplementor(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public ResultHandle ok(BytecodeCreator creator, ResultHandle entity) {
        ResultHandle builder = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Response.class, (String)"ok", Response.ResponseBuilder.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{entity});
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"build", Response.class, (Class[])new Class[0]), builder, new ResultHandle[0]);
    }

    public ResultHandle ok(BytecodeCreator creator, ResultHandle entity, ResultHandle links) {
        ResultHandle builder = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Response.class, (String)"ok", Response.ResponseBuilder.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{entity});
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"links", Response.ResponseBuilder.class, (Class[])new Class[]{Link[].class}), builder, new ResultHandle[]{links});
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"build", Response.class, (Class[])new Class[0]), builder, new ResultHandle[0]);
    }

    public ResultHandle created(BytecodeCreator creator, ResultHandle entity) {
        return this.created(creator, entity, this.getEntityUrl(creator, entity));
    }

    public ResultHandle created(BytecodeCreator creator, ResultHandle entity, ResultHandle location) {
        ResultHandle builder = this.getResponseBuilder(creator, Response.Status.CREATED.getStatusCode());
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"entity", Response.ResponseBuilder.class, (Class[])new Class[]{Object.class}), builder, new ResultHandle[]{entity});
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"location", Response.ResponseBuilder.class, (Class[])new Class[]{URI.class}), builder, new ResultHandle[]{location});
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"build", Response.class, (Class[])new Class[0]), builder, new ResultHandle[0]);
    }

    public ResultHandle getEntityUrl(BytecodeCreator creator, ResultHandle entity) {
        ResultHandle arcContainer = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instance = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), arcContainer, new ResultHandle[]{creator.loadClassFromTCCL(this.isResteasyClassic() ? ResteasyHalService.class : ResteasyReactiveHalService.class), creator.loadNull()});
        ResultHandle halService = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instance, new ResultHandle[0]);
        ResultHandle link = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(HalService.class, (String)"getSelfLink", String.class, (Class[])new Class[]{Object.class}), halService, new ResultHandle[]{entity});
        creator.ifNull(link).trueBranch().throwException(RuntimeException.class, "Could not extract a new entity URL");
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(URI.class, (String)"create", URI.class, (Class[])new Class[]{String.class}), new ResultHandle[]{link});
    }

    public ResultHandle noContent(BytecodeCreator creator) {
        return this.status(creator, Response.Status.NO_CONTENT.getStatusCode());
    }

    public ResultHandle notFound(BytecodeCreator creator) {
        return this.status(creator, Response.Status.NOT_FOUND.getStatusCode());
    }

    public ResultHandle notFoundException(BytecodeCreator creator) {
        return creator.newInstance(MethodDescriptor.ofConstructor(WebApplicationException.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{creator.load(Response.Status.NOT_FOUND.getStatusCode())});
    }

    private ResultHandle status(BytecodeCreator creator, int status) {
        ResultHandle builder = this.getResponseBuilder(creator, status);
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"build", Response.class, (Class[])new Class[0]), builder, new ResultHandle[0]);
    }

    private ResultHandle getResponseBuilder(BytecodeCreator creator, int status) {
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(Response.class, (String)"status", Response.ResponseBuilder.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{creator.load(status)});
    }

    private boolean isResteasyClassic() {
        return this.capabilities.isPresent("io.quarkus.resteasy");
    }
}

