/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.utils;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.MethodCreator;
import java.util.ArrayList;
import java.util.List;

public final class SignatureMethodCreator {
    public static MethodCreator getMethodCreator(String methodName, ClassCreator classCreator, ReturnType returnType, List<Parameter> parameters) {
        ArrayList<Object> paramTypes = new ArrayList<Object>();
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Parameter param : parameters) {
            paramNames.add(param.name);
            paramTypes.add(param.type);
        }
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator(methodName, classCreator, returnType, paramTypes.toArray(new Object[0]));
        methodCreator.setParameterNames(paramNames.toArray(new String[0]));
        return methodCreator;
    }

    public static MethodCreator getMethodCreator(String methodName, ClassCreator classCreator, ReturnType returnType, Object ... parameters) {
        MethodCreator methodCreator = classCreator.getMethodCreator(methodName, returnType.type, parameters);
        StringBuilder signatureBuilder = new StringBuilder();
        signatureBuilder.append("(");
        SignatureMethodCreator.parametersToSignature(signatureBuilder, parameters);
        signatureBuilder.append(")");
        signatureBuilder.append(SignatureMethodCreator.stringToSignature(returnType.type.getName()));
        if (returnType.parameterTypes.length > 0) {
            signatureBuilder.append("<");
            SignatureMethodCreator.parametersToSignature(signatureBuilder, returnType.parameterTypes);
            signatureBuilder.append(">");
        }
        signatureBuilder.append(";");
        methodCreator.setSignature(signatureBuilder.toString());
        return methodCreator;
    }

    private static void parametersToSignature(StringBuilder signatureBuilder, Object[] parameters) {
        for (Object parameter : parameters) {
            if (parameter instanceof Class) {
                signatureBuilder.append(DescriptorUtils.classToStringRepresentation((Class)((Class)parameter)));
                continue;
            }
            if (!(parameter instanceof String)) continue;
            signatureBuilder.append(SignatureMethodCreator.stringToSignature((String)parameter) + ";");
        }
    }

    private static String stringToSignature(String className) {
        return "L" + className.replace('.', '/');
    }

    public static ReturnType ofType(Class<?> type, Object ... parameterTypes) {
        ReturnType returnType = new ReturnType();
        returnType.type = type;
        returnType.parameterTypes = parameterTypes;
        return returnType;
    }

    public static Parameter param(String name, Object type) {
        Parameter parameter = new Parameter();
        parameter.name = name;
        parameter.type = type;
        return parameter;
    }

    public static class ReturnType {
        private Class<?> type;
        private Object[] parameterTypes;
    }

    public static class Parameter {
        private String name;
        private Object type;

        public String getName() {
            return this.name;
        }
    }
}

