/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import javax.ws.rs.core.Response;

public final class DeleteMethodImplementor
extends StandardMethodImplementor {
    private static final String METHOD_NAME = "delete";
    private static final String RESOURCE_METHOD_NAME = "delete";
    private static final String REL = "remove";

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = classCreator.getMethodCreator("delete", Response.class, new Object[]{resourceMetadata.getIdType()});
        this.addPathAnnotation((AnnotatedElement)methodCreator, this.appendToPath(resourceProperties.getPath("delete"), "{id}"));
        this.addDeleteAnnotation((AnnotatedElement)methodCreator);
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceMetadata.getEntityType(), REL);
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle id = methodCreator.getMethodParam(0);
        TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, "Failed to delete an entity");
        ResultHandle deleted = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"delete", Boolean.TYPE, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id});
        BranchResult entityWasDeleted = tryBlock.ifNonZero(deleted);
        entityWasDeleted.trueBranch().returnValue(ResponseImplementor.noContent(entityWasDeleted.trueBranch()));
        entityWasDeleted.falseBranch().returnValue(ResponseImplementor.notFound(entityWasDeleted.falseBranch()));
        tryBlock.close();
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return "delete";
    }
}

