/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods.hal;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.hal.HalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import javax.ws.rs.core.Response;

public final class GetHalMethodImplementor
extends HalMethodImplementor {
    private static final String METHOD_NAME = "getHal";
    private static final String RESOURCE_METHOD_NAME = "get";

    public GetHalMethodImplementor(boolean isResteasyClassic) {
        super(isResteasyClassic);
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = classCreator.getMethodCreator(METHOD_NAME, Response.class, new Object[]{resourceMetadata.getIdType()});
        this.addPathAnnotation((AnnotatedElement)methodCreator, this.appendToPath(resourceProperties.getPath(RESOURCE_METHOD_NAME), "{id}"));
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle id = methodCreator.getMethodParam(0);
        TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, "Failed to get an entity");
        ResultHandle entity = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)RESOURCE_METHOD_NAME, Object.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id});
        BranchResult wasNotFound = tryBlock.ifNull(entity);
        wasNotFound.trueBranch().returnValue(ResponseImplementor.notFound(wasNotFound.trueBranch()));
        wasNotFound.falseBranch().returnValue(ResponseImplementor.ok(wasNotFound.falseBranch(), this.wrapHalEntity(wasNotFound.falseBranch(), entity)));
        tryBlock.close();
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return RESOURCE_METHOD_NAME;
    }
}

