/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods.hal;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.hal.HalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.PaginationImplementor;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import io.quarkus.rest.data.panache.deployment.utils.SortImplementor;
import io.quarkus.rest.data.panache.runtime.hal.HalCollectionWrapper;
import java.util.List;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public final class ListHalMethodImplementor
extends HalMethodImplementor {
    private static final String METHOD_NAME = "listHal";
    private static final String RESOURCE_METHOD_NAME = "list";
    private final PaginationImplementor paginationImplementor = new PaginationImplementor();
    private final SortImplementor sortImplementor = new SortImplementor();

    public ListHalMethodImplementor(boolean isResteasyClassic) {
        super(isResteasyClassic);
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        if (resourceProperties.isPaged()) {
            this.implementPaged(classCreator, resourceMetadata, resourceProperties, resourceField);
        } else {
            this.implementNotPaged(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }

    @Override
    protected String getResourceMethodName() {
        return RESOURCE_METHOD_NAME;
    }

    private void implementPaged(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = classCreator.getMethodCreator(METHOD_NAME, Response.class, new Class[]{List.class, Integer.TYPE, Integer.TYPE, UriInfo.class});
        this.addPathAnnotation((AnnotatedElement)methodCreator, resourceProperties.getPath(RESOURCE_METHOD_NAME));
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        this.addSortQueryParamValidatorAnnotation((AnnotatedElement)methodCreator);
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(0), "sort");
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(1), "page");
        this.addDefaultValueAnnotation(methodCreator.getParameterAnnotations(1), Integer.toString(0));
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(2), "size");
        this.addDefaultValueAnnotation(methodCreator.getParameterAnnotations(2), Integer.toString(20));
        this.addContextAnnotation(methodCreator.getParameterAnnotations(3));
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle sortQuery = methodCreator.getMethodParam(0);
        ResultHandle sort = this.sortImplementor.getSort((BytecodeCreator)methodCreator, sortQuery);
        ResultHandle pageIndex = methodCreator.getMethodParam(1);
        ResultHandle pageSize = methodCreator.getMethodParam(2);
        ResultHandle page = this.paginationImplementor.getPage((BytecodeCreator)methodCreator, pageIndex, pageSize);
        ResultHandle uriInfo = methodCreator.getMethodParam(3);
        TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, "Failed to list the entities");
        ResultHandle pageCount = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"$$_page_count_list", Integer.TYPE, (Object[])new Object[]{Page.class}), resource, new ResultHandle[]{page});
        ResultHandle links = this.paginationImplementor.getLinks((BytecodeCreator)tryBlock, uriInfo, page, pageCount);
        ResultHandle entities = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)RESOURCE_METHOD_NAME, List.class, (Object[])new Object[]{Page.class, Sort.class}), resource, new ResultHandle[]{page, sort});
        ResultHandle wrapper = this.wrapHalEntities((BytecodeCreator)tryBlock, entities, resourceMetadata.getEntityType(), resourceProperties.getHalCollectionName());
        tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(HalCollectionWrapper.class, (String)"addLinks", Void.TYPE, (Class[])new Class[]{Link[].class}), wrapper, new ResultHandle[]{links});
        tryBlock.returnValue(ResponseImplementor.ok((BytecodeCreator)tryBlock, wrapper, links));
        tryBlock.close();
        methodCreator.close();
    }

    private void implementNotPaged(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceFieldDescriptor) {
        MethodCreator methodCreator = classCreator.getMethodCreator(METHOD_NAME, Response.class, new Class[]{List.class});
        this.addPathAnnotation((AnnotatedElement)methodCreator, resourceProperties.getPath(RESOURCE_METHOD_NAME));
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/hal+json");
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(0), "sort");
        ResultHandle sortQuery = methodCreator.getMethodParam(0);
        ResultHandle sort = this.sortImplementor.getSort((BytecodeCreator)methodCreator, sortQuery);
        ResultHandle resource = methodCreator.readInstanceField(resourceFieldDescriptor, methodCreator.getThis());
        TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, "Failed to list the entities");
        ResultHandle entities = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)RESOURCE_METHOD_NAME, List.class, (Object[])new Object[]{Page.class, Sort.class}), resource, new ResultHandle[]{tryBlock.loadNull(), sort});
        ResultHandle wrapper = this.wrapHalEntities((BytecodeCreator)tryBlock, entities, resourceMetadata.getEntityType(), resourceProperties.getHalCollectionName());
        tryBlock.returnValue(ResponseImplementor.ok((BytecodeCreator)tryBlock, wrapper));
        tryBlock.close();
        methodCreator.close();
    }
}

