/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.SignatureMethodCreator;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.core.Response;

public final class GetMethodImplementor
extends StandardMethodImplementor {
    private static final String METHOD_NAME = "get";
    private static final String RESOURCE_METHOD_NAME = "get";
    private static final String EXCEPTION_MESSAGE = "Failed to get an entity";
    private static final String REL = "self";

    public GetMethodImplementor(Capabilities capabilities) {
        super(capabilities);
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator("get", classCreator, this.isNotReactivePanache() ? SignatureMethodCreator.responseType() : SignatureMethodCreator.uniType(resourceMetadata.getEntityType()), SignatureMethodCreator.param("id", resourceMetadata.getIdType()));
        this.addPathAnnotation((AnnotatedElement)methodCreator, this.appendToPath(resourceProperties.getPath("get"), "{id}"));
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addProducesJsonAnnotation((AnnotatedElement)methodCreator, resourceProperties);
        this.addMethodAnnotations((AnnotatedElement)methodCreator, resourceProperties.getMethodAnnotations("get"));
        this.addOpenApiResponseAnnotation((AnnotatedElement)methodCreator, Response.Status.OK, resourceMetadata.getEntityType());
        this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceMetadata.getEntityType(), REL);
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle id = methodCreator.getMethodParam(0);
        if (this.isNotReactivePanache()) {
            TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, EXCEPTION_MESSAGE);
            ResultHandle entity2 = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"get", Object.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id});
            BranchResult wasNotFound = tryBlock.ifNull(entity2);
            wasNotFound.trueBranch().returnValue(this.responseImplementor.notFound(wasNotFound.trueBranch()));
            wasNotFound.falseBranch().returnValue(this.responseImplementor.ok(wasNotFound.falseBranch(), entity2));
            tryBlock.close();
        } else {
            ResultHandle uniEntity = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"get", Uni.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id});
            methodCreator.returnValue(UniImplementor.map((BytecodeCreator)methodCreator, uniEntity, EXCEPTION_MESSAGE, (body, entity) -> {
                BranchResult entityWasNotFound = body.ifNull(entity);
                entityWasNotFound.trueBranch().returnValue(this.responseImplementor.notFound(entityWasNotFound.trueBranch()));
                entityWasNotFound.falseBranch().returnValue(this.responseImplementor.ok(entityWasNotFound.falseBranch(), (ResultHandle)entity));
            }));
        }
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return "get";
    }
}

