/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.SignatureMethodCreator;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.core.Response;

public final class CountMethodImplementor
extends StandardMethodImplementor {
    private static final String METHOD_NAME = "count";
    private static final String RESOURCE_METHOD_NAME = "count";
    private static final String EXCEPTION_MESSAGE = "Failed to count the entities";
    private static final String REL = "count";

    public CountMethodImplementor(Capabilities capabilities) {
        super(capabilities);
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator("count", classCreator, this.isNotReactivePanache() ? SignatureMethodCreator.responseType() : SignatureMethodCreator.uniType(Long.class), new SignatureMethodCreator.Parameter[0]);
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addPathAnnotation((AnnotatedElement)methodCreator, this.appendToPath(resourceProperties.getPath("count"), "count"));
        this.addMethodAnnotations((AnnotatedElement)methodCreator, resourceProperties.getMethodAnnotations("count"));
        this.addOpenApiResponseAnnotation((AnnotatedElement)methodCreator, Response.Status.OK, Long.class, false);
        this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
        if (!this.isResteasyClassic()) {
            this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceMetadata.getEntityType(), "count");
        }
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        if (this.isNotReactivePanache()) {
            TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, EXCEPTION_MESSAGE);
            ResultHandle count2 = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"count", Long.TYPE, (Object[])new Object[0]), resource, new ResultHandle[0]);
            tryBlock.returnValue(this.responseImplementor.ok((BytecodeCreator)tryBlock, count2));
            tryBlock.close();
        } else {
            ResultHandle uniCount = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"count", Uni.class, (Object[])new Object[0]), resource, new ResultHandle[0]);
            methodCreator.returnValue(UniImplementor.map((BytecodeCreator)methodCreator, uniCount, EXCEPTION_MESSAGE, (countBody, count) -> countBody.returnValue(this.responseImplementor.ok((BytecodeCreator)countBody, (ResultHandle)count))));
        }
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return "count";
    }
}

