/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.utils;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.panache.common.Page;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public final class PaginationImplementor {
    public static final int DEFAULT_PAGE_INDEX = 0;
    public static final int DEFAULT_PAGE_SIZE = 20;

    public ResultHandle getPage(BytecodeCreator creator, ResultHandle index, ResultHandle size) {
        ResultHandle validIndex = this.getValidOrDefault(creator, index, 0, 0);
        ResultHandle validSize = this.getValidOrDefault(creator, size, 1, 20);
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(Page.class, (String)"of", Page.class, (Class[])new Class[]{Integer.TYPE, Integer.TYPE}), new ResultHandle[]{validIndex, validSize});
    }

    private ResultHandle getValidOrDefault(BytecodeCreator creator, ResultHandle value, int minValue, int defaultValue) {
        AssignableResultHandle result = creator.createVariable(Integer.TYPE);
        BranchResult isValid = creator.ifIntegerGreaterEqual(value, creator.load(minValue));
        isValid.trueBranch().assign(result, value);
        isValid.falseBranch().assign(result, isValid.falseBranch().load(defaultValue));
        return result;
    }

    public ResultHandle getLinks(BytecodeCreator creator, ResultHandle uriInfo, ResultHandle page, ResultHandle pageCount) {
        ResultHandle links = creator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{creator.load(4)});
        ResultHandle firstPage = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Page.class, (String)"first", Page.class, (Class[])new Class[0]), page, new ResultHandle[0]);
        ResultHandle firstPageLink = this.getLink(creator, uriInfo, firstPage, "first");
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), links, new ResultHandle[]{firstPageLink});
        ResultHandle lastPage = this.getLastPage(creator, page, pageCount);
        ResultHandle lastPageLink = this.getLink(creator, uriInfo, lastPage, "last");
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), links, new ResultHandle[]{lastPageLink});
        BytecodeCreator previousPageCreator = this.isTheSamePage(creator, page, firstPage).falseBranch();
        ResultHandle previousPage = previousPageCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Page.class, (String)"previous", Page.class, (Class[])new Class[0]), page, new ResultHandle[0]);
        ResultHandle previousPageLink = this.getLink(previousPageCreator, uriInfo, previousPage, "previous");
        previousPageCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), links, new ResultHandle[]{previousPageLink});
        BytecodeCreator nextPageCreator = this.isTheSamePage(creator, page, lastPage).falseBranch();
        ResultHandle nextPage = nextPageCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Page.class, (String)"next", Page.class, (Class[])new Class[0]), page, new ResultHandle[0]);
        ResultHandle nextPageLink = this.getLink(nextPageCreator, uriInfo, nextPage, "next");
        nextPageCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), links, new ResultHandle[]{nextPageLink});
        ResultHandle linksCount = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"size", Integer.TYPE, (Class[])new Class[0]), links, new ResultHandle[0]);
        ResultHandle linksArray = creator.newArray(Link.class, linksCount);
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"toArray", Object[].class, (Class[])new Class[]{Object[].class}), links, new ResultHandle[]{linksArray});
    }

    private ResultHandle getLink(BytecodeCreator creator, ResultHandle uriInfo, ResultHandle page, String rel) {
        ResultHandle builder = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Link.class, (String)"fromUri", Link.Builder.class, (Class[])new Class[]{URI.class}), new ResultHandle[]{this.getPageUri(creator, uriInfo, page)});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Link.Builder.class, (String)"rel", Link.Builder.class, (Class[])new Class[]{String.class}), builder, new ResultHandle[]{creator.load(rel)});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Link.Builder.class, (String)"build", Link.class, (Class[])new Class[]{Object[].class}), builder, new ResultHandle[]{creator.newArray(Object.class, 0)});
    }

    private ResultHandle getPageUri(BytecodeCreator creator, ResultHandle uriInfo, ResultHandle page) {
        ResultHandle uriBuilder = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(UriInfo.class, (String)"getAbsolutePathBuilder", UriBuilder.class, (Class[])new Class[0]), uriInfo, new ResultHandle[0]);
        ResultHandle index = creator.readInstanceField(FieldDescriptor.of(Page.class, (String)"index", Integer.TYPE), page);
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(UriBuilder.class, (String)"queryParam", UriBuilder.class, (Class[])new Class[]{String.class, Object[].class}), uriBuilder, new ResultHandle[]{creator.load("page"), creator.marshalAsArray(Object.class, new ResultHandle[]{index})});
        ResultHandle size = creator.readInstanceField(FieldDescriptor.of(Page.class, (String)"size", Integer.TYPE), page);
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(UriBuilder.class, (String)"queryParam", UriBuilder.class, (Class[])new Class[]{String.class, Object[].class}), uriBuilder, new ResultHandle[]{creator.load("size"), creator.marshalAsArray(Object.class, new ResultHandle[]{size})});
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(UriBuilder.class, (String)"build", URI.class, (Class[])new Class[]{Object[].class}), uriBuilder, new ResultHandle[]{creator.newArray(Object.class, 0)});
    }

    private ResultHandle getLastPage(BytecodeCreator creator, ResultHandle page, ResultHandle pageCount) {
        ResultHandle pageNumber = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Math.class, (String)"max", Integer.TYPE, (Class[])new Class[]{Integer.TYPE, Integer.TYPE}), new ResultHandle[]{creator.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"sum", Integer.TYPE, (Class[])new Class[]{Integer.TYPE, Integer.TYPE}), new ResultHandle[]{pageCount, creator.load(-1)}), creator.load(0)});
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Page.class, (String)"index", Page.class, (Class[])new Class[]{Integer.TYPE}), page, new ResultHandle[]{pageNumber});
    }

    private BranchResult isTheSamePage(BytecodeCreator creator, ResultHandle page, ResultHandle anotherPage) {
        ResultHandle index = creator.readInstanceField(FieldDescriptor.of(Page.class, (String)"index", Integer.TYPE), page);
        ResultHandle anotherIndex = creator.readInstanceField(FieldDescriptor.of(Page.class, (String)"index", Integer.TYPE), anotherPage);
        return creator.ifIntegerEqual(index, anotherIndex);
    }
}

