/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.AddMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.CountMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.DeleteMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.GetMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.ListMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.MethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.UpdateMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.UserMethodsWithTransactionalImplementor;
import io.quarkus.rest.data.panache.deployment.methods.hal.ListHalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.runtime.util.HashUtil;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.logging.Logger;

class JaxRsResourceImplementor {
    private static final Logger LOGGER = Logger.getLogger(JaxRsResourceImplementor.class);
    private static final String OPENAPI_TAG_ANNOTATION = "org.eclipse.microprofile.openapi.annotations.tags.Tag";
    private static final String WITH_SESSION_ON_DEMAND_ANNOTATION = "io.quarkus.hibernate.reactive.panache.common.WithSessionOnDemand";
    private final List<MethodImplementor> methodImplementors;

    JaxRsResourceImplementor(Capabilities capabilities) {
        this.methodImplementors = Arrays.asList(new GetMethodImplementor(capabilities), new ListMethodImplementor(capabilities), new CountMethodImplementor(capabilities), new AddMethodImplementor(capabilities), new UpdateMethodImplementor(capabilities), new DeleteMethodImplementor(capabilities), new UserMethodsWithTransactionalImplementor(capabilities), new ListHalMethodImplementor(capabilities));
    }

    void implement(ClassOutput classOutput, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, Capabilities capabilities) {
        String controllerClassName = resourceMetadata.getResourceName() + "JaxRs_" + HashUtil.sha1((String)resourceMetadata.getResourceName());
        LOGGER.tracef("Starting generation of '%s'", (Object)controllerClassName);
        ClassCreator.Builder classCreatorBuilder = ClassCreator.builder().classOutput(classOutput).className(controllerClassName);
        if (resourceMetadata.getResourceInterface() != null) {
            classCreatorBuilder.interfaces(new String[]{resourceMetadata.getResourceInterface().name().toString()});
        }
        ClassCreator classCreator = classCreatorBuilder.build();
        if (resourceMetadata.getResourceInterface() != null) {
            classCreator.addAnnotation(Alternative.class);
            classCreator.addAnnotation(Priority.class).add("value", (Object)Integer.MIN_VALUE);
        }
        this.implementClassAnnotations(classCreator, resourceMetadata, resourceProperties, capabilities);
        FieldDescriptor resourceField = this.implementResourceField(classCreator, resourceMetadata);
        this.implementMethods(classCreator, resourceMetadata, resourceProperties, resourceField);
        classCreator.close();
        LOGGER.tracef("Completed generation of '%s'", (Object)controllerClassName);
    }

    private void implementClassAnnotations(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, Capabilities capabilities) {
        classCreator.addAnnotation(Path.class).addValue("value", (Object)resourceProperties.getPath());
        if (capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            String className = StringUtils.substringAfterLast((String)resourceMetadata.getResourceName(), (String)".");
            classCreator.addAnnotation(OPENAPI_TAG_ANNOTATION).add("name", (Object)className);
        }
        if (resourceProperties.getClassAnnotations() != null) {
            for (AnnotationInstance classAnnotation : resourceProperties.getClassAnnotations()) {
                classCreator.addAnnotation(classAnnotation);
            }
        }
        if (capabilities.isPresent("io.quarkus.hibernate.reactive")) {
            classCreator.addAnnotation(WITH_SESSION_ON_DEMAND_ANNOTATION);
        }
    }

    private FieldDescriptor implementResourceField(ClassCreator classCreator, ResourceMetadata resourceMetadata) {
        FieldCreator resourceFieldCreator = classCreator.getFieldCreator("resource", resourceMetadata.getResourceClass());
        ((FieldCreator)resourceFieldCreator.setModifiers(resourceFieldCreator.getModifiers() & 0xFFFFFFFD)).addAnnotation(Inject.class);
        return resourceFieldCreator.getFieldDescriptor();
    }

    private void implementMethods(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        for (MethodImplementor methodImplementor : this.methodImplementors) {
            methodImplementor.implement(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }
}

