/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.MethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public final class UserMethodsWithTransactionalImplementor
implements MethodImplementor {
    public static final DotName TRANSACTIONAL = DotName.createSimple((String)"jakarta.transaction.Transactional");
    private final Capabilities capabilities;

    public UserMethodsWithTransactionalImplementor(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public void implement(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        if (this.capabilities.isPresent("io.quarkus.hibernate.orm") && resourceMetadata.getResourceInterface() != null) {
            for (MethodInfo methodInfo : resourceMetadata.getResourceInterface().methods()) {
                if (!methodInfo.hasAnnotation(TRANSACTIONAL)) continue;
                MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)methodInfo));
                methodCreator.setSignature(methodInfo.genericSignatureIfRequired());
                for (AnnotationInstance annotation : methodInfo.annotations()) {
                    if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                        short position = annotation.target().asMethodParameter().position();
                        methodCreator.getParameterAnnotations((int)position).addAnnotation(annotation);
                    }
                    if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                    methodCreator.addAnnotation(annotation);
                }
                ResultHandle[] params = new ResultHandle[methodInfo.parametersCount()];
                for (int paramIdx = 0; paramIdx < methodInfo.parametersCount(); ++paramIdx) {
                    params[paramIdx] = methodCreator.getMethodParam(paramIdx);
                }
                methodCreator.returnValue(methodCreator.invokeSpecialInterfaceMethod(methodInfo, methodCreator.getThis(), params));
                methodCreator.close();
            }
        }
    }
}

