/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.utils;

import io.quarkus.rest.data.panache.deployment.ResourceMethodListenerBuildItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public final class EntityTypeUtils {
    private EntityTypeUtils() {
    }

    public static Map<String, Type> getEntityFields(IndexView index, String entityTypeName) {
        HashMap<String, Type> fields = new HashMap<String, Type>();
        ClassInfo currentEntityClass = index.getClassByName(entityTypeName);
        while (currentEntityClass != null) {
            for (FieldInfo field : currentEntityClass.fields()) {
                fields.put(field.name(), field.type());
            }
            if (currentEntityClass.superName() != null) {
                currentEntityClass = index.getClassByName(currentEntityClass.superName());
                continue;
            }
            currentEntityClass = null;
        }
        return fields;
    }

    public static List<ClassInfo> getListenersByEntityType(IndexView index, List<ResourceMethodListenerBuildItem> resourceMethodListeners, String entityTypeName) {
        ClassInfo entityClass = index.getClassByName(entityTypeName);
        return resourceMethodListeners.stream().filter(EntityTypeUtils.isCompatibleWithEntityType(index, entityClass)).map(e -> e.getClassInfo()).collect(Collectors.toList());
    }

    private static Predicate<ResourceMethodListenerBuildItem> isCompatibleWithEntityType(IndexView index, ClassInfo entityClass) {
        return e -> {
            DotName entityTypeOfListener = e.getEntityType().asClassType().name();
            ClassInfo currentEntityClass = entityClass;
            while (currentEntityClass != null) {
                if (entityTypeOfListener.equals((Object)currentEntityClass.name())) {
                    return true;
                }
                if (currentEntityClass.superName() != null) {
                    currentEntityClass = index.getClassByName(currentEntityClass.superName());
                    continue;
                }
                currentEntityClass = null;
            }
            return false;
        };
    }
}

