/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jaxb.runtime.serialisers;

import io.quarkus.jaxb.runtime.JaxbContextConfigRecorder;
import io.vertx.core.MultiMap;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.beans.Introspector;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class ServerJaxbMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    @Inject
    Marshaller marshaller;
    @Context
    Providers providers;

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        this.setContentTypeIfNecessary(httpHeaders);
        this.marshal(o, entityStream);
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        this.setContentTypeIfNecessary(context);
        OutputStream stream = context.getOrCreateOutputStream();
        this.marshal(o, stream);
        stream.close();
    }

    protected void marshal(Object o, OutputStream outputStream) {
        try {
            Class clazz = o.getClass();
            Object jaxbObject = o;
            if (o instanceof JAXBElement) {
                clazz = ((JAXBElement)o).getDeclaredType();
            } else {
                XmlRootElement jaxbElement = clazz.getAnnotation(XmlRootElement.class);
                if (jaxbElement == null) {
                    jaxbObject = new JAXBElement(new QName(Introspector.decapitalize(clazz.getSimpleName())), clazz, o);
                }
            }
            this.getMarshall(clazz).marshal(jaxbObject, outputStream);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private Marshaller getMarshall(Class<?> type) throws JAXBException {
        if (JaxbContextConfigRecorder.isClassBound(type)) {
            return this.marshaller;
        }
        return ((JAXBContext)this.providers.getContextResolver(JAXBContext.class, MediaType.APPLICATION_XML_TYPE).getContext(type)).createMarshaller();
    }

    private void setContentTypeIfNecessary(MultivaluedMap<String, Object> httpHeaders) {
        Object contentType = httpHeaders.getFirst((Object)"Content-Type");
        if (this.isNotXml(contentType)) {
            httpHeaders.putSingle((Object)"Content-Type", (Object)"application/xml");
        }
    }

    private void setContentTypeIfNecessary(ServerRequestContext context) {
        String currentContentType = null;
        Iterable responseHeaders = context.serverResponse().getAllResponseHeaders();
        if (responseHeaders instanceof MultiMap) {
            currentContentType = ((MultiMap)responseHeaders).get("Content-Type");
        } else {
            for (Map.Entry entry : responseHeaders) {
                if (!((String)entry.getKey()).equalsIgnoreCase("Content-Type")) continue;
                currentContentType = (String)entry.getValue();
                break;
            }
        }
        if (this.isNotXml(currentContentType)) {
            context.serverResponse().setResponseHeader((CharSequence)"Content-Type", (CharSequence)"application/xml");
        }
    }

    private boolean isNotXml(Object contentType) {
        return contentType == null || !contentType.toString().contains("xml");
    }
}

