/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jsonb.common.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.jsonb.spi.JsonbDeserializerBuildItem;
import io.quarkus.jsonb.spi.JsonbSerializerBuildItem;
import io.quarkus.resteasy.reactive.jsonb.common.runtime.serialisers.VertxJson;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import jakarta.ws.rs.RuntimeType;
import java.util.Collections;
import java.util.List;
import org.jboss.resteasy.reactive.server.jsonb.JsonbMessageBodyReader;
import org.jboss.resteasy.reactive.server.jsonb.JsonbMessageBodyWriter;

public class ResteasyReactiveJsonbCommonProcessor {
    private static final List<String> VERTX_SERIALIZERS = List.of(VertxJson.JsonObjectSerializer.class.getName(), VertxJson.JsonArraySerializer.class.getName());
    private static final List<String> VERTX_DESERIALIZERS = List.of(VertxJson.JsonObjectDeserializer.class.getName(), VertxJson.JsonArrayDeserializer.class.getName());

    @BuildStep
    public void registerVertxJsonSupport(BuildProducer<JsonbSerializerBuildItem> serializers, BuildProducer<JsonbDeserializerBuildItem> deserializers) {
        serializers.produce((BuildItem)new JsonbSerializerBuildItem(VERTX_SERIALIZERS));
        deserializers.produce((BuildItem)new JsonbDeserializerBuildItem(VERTX_DESERIALIZERS));
    }

    @BuildStep
    public void beans(BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(JsonbMessageBodyReader.class.getName()).addBeanClass(JsonbMessageBodyWriter.class.getName()).setUnremovable().build());
    }

    public static void additionalProviders(BuildProducer<MessageBodyReaderBuildItem> additionalReaders, BuildProducer<MessageBodyWriterBuildItem> additionalWriters, RuntimeType runtimeType) {
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(JsonbMessageBodyReader.class.getName(), Object.class.getName()).setMediaTypeStrings(Collections.singletonList("application/json")).setBuiltin(true).setRuntimeType(runtimeType).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(JsonbMessageBodyWriter.class.getName(), Object.class.getName()).setMediaTypeStrings(List.of("application/json", "application/x-ndjson", "application/stream+json")).setBuiltin(true).setRuntimeType(runtimeType).build());
    }
}

