/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.kotlin.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.HashUtil;
import org.jboss.resteasy.reactive.server.core.parameters.NullParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.handlers.PublisherResponseHandler;
import org.jboss.resteasy.reactive.server.model.FixedHandlersChainCustomizer;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.runtime.kotlin.CoroutineEndpointInvoker;
import org.jboss.resteasy.reactive.server.runtime.kotlin.CoroutineMethodProcessor;
import org.jboss.resteasy.reactive.server.runtime.kotlin.FlowToPublisherHandler;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;
import org.jboss.resteasy.reactive.server.spi.EndpointInvokerFactory;

public class KotlinCoroutineIntegrationProcessor {
    static final DotName CONTINUATION = DotName.createSimple((String)"kotlin.coroutines.Continuation");
    static final DotName FLOW = DotName.createSimple((String)"kotlinx.coroutines.flow.Flow");
    public static final String NAME = KotlinCoroutineIntegrationProcessor.class.getName();
    private static final DotName BLOCKING_ANNOTATION = DotName.createSimple((String)"io.smallrye.common.annotation.Blocking");

    @BuildStep
    void produceCoroutineScope(BuildProducer<AdditionalBeanBuildItem> buildItemBuildProducer) {
        buildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new String[]{"org.jboss.resteasy.reactive.server.runtime.kotlin.CoroutineInvocationHandlerFactory", "org.jboss.resteasy.reactive.server.runtime.kotlin.ApplicationCoroutineScope"}).setUnremovable().build());
    }

    @BuildStep
    MethodScannerBuildItem scanner() {
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                if (methodContext.containsKey(NAME)) {
                    Type methodReturnType;
                    this.ensureNotBlocking(method);
                    EndpointInvokerFactory recorder = (EndpointInvokerFactory)methodContext.get(EndpointInvokerFactory.class.getName());
                    CoroutineMethodProcessor processor = new CoroutineMethodProcessor(KotlinCoroutineIntegrationProcessor.this.createCoroutineInvoker(method.declaringClass(), method, (BuildProducer<GeneratedClassBuildItem>)((BuildProducer)methodContext.get(GeneratedClassBuildItem.class.getName())), recorder));
                    if (methodContext.containsKey("METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY") && (methodReturnType = (Type)methodContext.get("METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY")) != null && methodReturnType.name().equals((Object)FLOW)) {
                        return List.of(processor, KotlinCoroutineIntegrationProcessor.flowCustomizer());
                    }
                    return Collections.singletonList(processor);
                }
                return Collections.emptyList();
            }

            private void ensureNotBlocking(MethodInfo method) {
                if (method.annotation(BLOCKING_ANNOTATION) != null) {
                    String format = String.format("Suspendable @Blocking methods are not supported yet: %s.%s", method.declaringClass().name(), method.name());
                    throw new IllegalStateException(format);
                }
            }

            public ParameterExtractor handleCustomParameter(Type paramType, Map<DotName, AnnotationInstance> annotations, boolean field, Map<String, Object> methodContext) {
                if (paramType.name().equals((Object)CONTINUATION)) {
                    Type firstGenericType;
                    methodContext.put(NAME, true);
                    if (paramType.kind() == Type.Kind.PARAMETERIZED_TYPE && (firstGenericType = (Type)paramType.asParameterizedType().arguments().get(0)).kind() == Type.Kind.WILDCARD_TYPE) {
                        methodContext.put("METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY", firstGenericType.asWildcardType().superBound());
                    }
                    return new NullParamExtractor();
                }
                return null;
            }

            public boolean isMethodSignatureAsync(MethodInfo info) {
                for (Type param : info.parameterTypes()) {
                    if (!param.name().equals((Object)CONTINUATION)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private Supplier<EndpointInvoker> createCoroutineInvoker(ClassInfo currentClassInfo, MethodInfo info, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, EndpointInvokerFactory factory) {
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(info.name()).append(info.returnType());
        for (Type t : info.parameterTypes()) {
            sigBuilder.append(t);
        }
        String baseName = String.valueOf(currentClassInfo.name()) + "$quarkuscoroutineinvoker$" + info.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        try (ClassCreator classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true), baseName, null, Object.class.getName(), new String[]{CoroutineEndpointInvoker.class.getName()});){
            try (MethodCreator mc = classCreator.getMethodCreator("invoke", Object.class, new Class[]{Object.class, Object[].class});){
                mc.throwException(IllegalStateException.class, "Incorrect invoker used for Kotlin suspendable method");
            }
            mc = classCreator.getMethodCreator("invokeCoroutine", Object.class, new Object[]{Object.class, Object[].class, CONTINUATION.toString()});
            try {
                ResultHandle[] args = new ResultHandle[info.parametersCount()];
                ResultHandle array = mc.getMethodParam(1);
                for (int i = 0; i < info.parametersCount() - 1; ++i) {
                    args[i] = mc.readArrayValue(array, i);
                }
                args[args.length - 1] = mc.getMethodParam(2);
                ResultHandle res = Modifier.isInterface(currentClassInfo.flags()) ? mc.invokeInterfaceMethod(info, mc.getMethodParam(0), args) : mc.invokeVirtualMethod(info, mc.getMethodParam(0), args);
                if (info.returnType().kind() == Type.Kind.VOID) {
                    mc.returnValue(mc.loadNull());
                } else {
                    mc.returnValue(res);
                }
            }
            finally {
                if (mc != null) {
                    mc.close();
                }
            }
        }
        return factory.invoker(baseName);
    }

    @BuildStep
    public MethodScannerBuildItem flowSupport() {
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                DotName returnTypeName = method.returnType().name();
                if (returnTypeName.equals((Object)FLOW)) {
                    return Collections.singletonList(KotlinCoroutineIntegrationProcessor.flowCustomizer());
                }
                return Collections.emptyList();
            }

            public boolean isMethodSignatureAsync(MethodInfo info) {
                return info.returnType().name().equals((Object)FLOW);
            }
        });
    }

    private static HandlerChainCustomizer flowCustomizer() {
        return new FixedHandlersChainCustomizer(List.of(new FlowToPublisherHandler(), new PublisherResponseHandler()), HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE);
    }
}

