/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.runtime;

import io.quarkus.resteasy.reactive.links.RestLinksProvider;
import io.quarkus.resteasy.reactive.links.runtime.GetterAccessor;
import io.quarkus.resteasy.reactive.links.runtime.GetterAccessorsContainer;
import io.quarkus.resteasy.reactive.links.runtime.LinkInfo;
import io.quarkus.resteasy.reactive.links.runtime.LinksContainer;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class RestLinksProviderImpl
implements RestLinksProvider {
    private static LinksContainer linksContainer;
    private static GetterAccessorsContainer getterAccessorsContainer;
    private final UriInfo uriInfo;

    static void setLinksContainer(LinksContainer context) {
        linksContainer = context;
    }

    static void setGetterAccessorsContainer(GetterAccessorsContainer getterAccessorsContainer) {
        RestLinksProviderImpl.getterAccessorsContainer = getterAccessorsContainer;
    }

    RestLinksProviderImpl(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public Collection<Link> getTypeLinks(Class<?> elementType) {
        this.verifyInit();
        List<LinkInfo> linkInfoList = linksContainer.getForClass(elementType);
        ArrayList<Link> links = new ArrayList<Link>(linkInfoList.size());
        for (LinkInfo linkInfo : linkInfoList) {
            if (linkInfo.getPathParameters().size() != 0) continue;
            links.add(this.linkBuilderFor(linkInfo).build(new Object[0]));
        }
        return links;
    }

    @Override
    public <T> Collection<Link> getInstanceLinks(T instance) {
        this.verifyInit();
        List<LinkInfo> linkInfoList = linksContainer.getForClass(instance.getClass());
        ArrayList<Link> links = new ArrayList<Link>(linkInfoList.size());
        for (LinkInfo linkInfo : linkInfoList) {
            links.add(this.linkBuilderFor(linkInfo).build(this.getPathParameterValues(linkInfo, instance)));
        }
        return links;
    }

    private Link.Builder linkBuilderFor(LinkInfo linkInfo) {
        Link.Builder builder = Link.fromUriBuilder((UriBuilder)this.uriInfo.getBaseUriBuilder().path(linkInfo.getPath())).rel(linkInfo.getRel());
        if (linkInfo.getTitle() != null) {
            builder.title(linkInfo.getTitle());
        }
        if (linkInfo.getType() != null) {
            builder.type(linkInfo.getType());
        }
        return builder;
    }

    private Object[] getPathParameterValues(LinkInfo linkInfo, Object instance) {
        ArrayList<Object> values = new ArrayList<Object>(linkInfo.getPathParameters().size());
        for (String name : linkInfo.getPathParameters()) {
            GetterAccessor accessor = getterAccessorsContainer.get(linkInfo.getEntityType(), name);
            if (accessor != null) {
                values.add(accessor.get(instance));
                continue;
            }
            values.add("{" + name + "}");
        }
        return values.toArray();
    }

    private void verifyInit() {
        if (linksContainer == null) {
            throw new IllegalStateException("Links context has not been initialized");
        }
        if (getterAccessorsContainer == null) {
            throw new IllegalStateException("Getter accessors container has not been initialized");
        }
    }
}

