/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.runtime;

import io.quarkus.resteasy.reactive.links.runtime.LinkInfo;
import io.quarkus.runtime.annotations.RecordableConstructor;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.List;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;

public final class LinksContainer {
    private final MultivaluedMap<String, LinkInfo> linksMap;

    public LinksContainer() {
        this.linksMap = new MultivaluedTreeMap();
    }

    @RecordableConstructor
    public LinksContainer(MultivaluedMap<String, LinkInfo> linksMap) {
        this.linksMap = linksMap;
    }

    public List<LinkInfo> getForClass(Class<?> c) {
        return (List)this.linksMap.getOrDefault((Object)c.getName(), Collections.emptyList());
    }

    public void put(LinkInfo linkInfo) {
        this.linksMap.add((Object)linkInfo.getEntityType(), (Object)linkInfo);
    }

    public MultivaluedMap<String, LinkInfo> getLinksMap() {
        return MultivaluedTreeMap.clone(this.linksMap);
    }
}

