/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.resteasy.reactive.server.runtime.StandardSecurityCheckInterceptor;
import io.quarkus.resteasy.reactive.server.runtime.security.EagerSecurityContext;
import io.quarkus.resteasy.reactive.server.runtime.security.ResourceMethodDescription;
import io.quarkus.resteasy.reactive.server.runtime.security.SecurityCheckWithMethodArgsHandler;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.vertx.http.runtime.security.AuthorizationPolicyStorage;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class EagerSecurityHandler
implements ServerRestHandler {
    private static final EagerSecurityHandler HTTP_PERMS_ONLY = new EagerSecurityHandler(null, false, null);
    private final SecurityCheck check;
    private final boolean isDefaultJaxRsSecCheck;
    private final MethodDescription invokedMethodDesc;

    private EagerSecurityHandler(SecurityCheck check, boolean isDefaultJaxRsSecCheck, MethodDescription invokedMethodDesc) {
        this.check = check;
        this.isDefaultJaxRsSecCheck = isDefaultJaxRsSecCheck;
        this.invokedMethodDesc = invokedMethodDesc;
    }

    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        Uni check;
        if (!EagerSecurityContext.instance.authorizationController.isAuthorizationEnabled()) {
            return;
        }
        if (this.isDefaultJaxRsSecCheck && EagerSecurityHandler.isRequestAlreadyChecked(requestContext)) {
            return;
        }
        Function<SecurityIdentity, Uni<?>> checkRequiringIdentity = this.check == null ? null : EagerSecurityHandler.getSecurityCheck(requestContext, this.check, this.invokedMethodDesc);
        if (checkRequiringIdentity == null) {
            if (EagerSecurityContext.instance.doNotRunPermissionSecurityCheck) {
                return;
            }
            check = Uni.createFrom().deferred(new Supplier<Uni<?>>(){

                @Override
                public Uni<?> get() {
                    return EagerSecurityContext.instance.getPermissionCheck(requestContext, null, EagerSecurityHandler.this.invokedMethodDesc);
                }
            });
        } else {
            check = EagerSecurityContext.instance.doNotRunPermissionSecurityCheck ? EagerSecurityContext.instance.getDeferredIdentity().chain(checkRequiringIdentity) : EagerSecurityContext.instance.getDeferredIdentity().flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                    return EagerSecurityContext.instance.getPermissionCheck(requestContext, securityIdentity, EagerSecurityHandler.this.invokedMethodDesc);
                }
            }).chain(checkRequiringIdentity);
        }
        requestContext.requireCDIRequestScope();
        requestContext.suspend();
        check.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<Object>(){

            public void onSubscribe(UniSubscription subscription) {
            }

            public void onItem(Object item) {
                requestContext.resume();
            }

            public void onFailure(Throwable failure) {
                requestContext.resume(failure, true);
            }
        });
    }

    private static Function<SecurityIdentity, Uni<?>> getSecurityCheck(final ResteasyReactiveRequestContext requestContext, final SecurityCheck check, final MethodDescription invokedMethodDesc) {
        if (check.isPermitAll()) {
            EagerSecurityContext.preventRepeatedSecurityChecks(requestContext, invokedMethodDesc);
            if (EagerSecurityContext.instance.eventHelper.fireEventOnSuccess()) {
                SecurityIdentity identity;
                User user;
                requestContext.requireCDIRequestScope();
                RoutingContext event = (RoutingContext)requestContext.unwrap(RoutingContext.class);
                if (event != null && (user = event.user()) instanceof QuarkusHttpUser) {
                    QuarkusHttpUser user2 = (QuarkusHttpUser)user;
                    identity = user2.getSecurityIdentity();
                } else {
                    identity = null;
                }
                EagerSecurityContext.instance.eventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(identity, check.getClass().getName(), EagerSecurityContext.createEventPropsWithRoutingCtx(requestContext), invokedMethodDesc));
            }
            return null;
        }
        return new Function<SecurityIdentity, Uni<?>>(){

            @Override
            public Uni<?> apply(SecurityIdentity securityIdentity) {
                if (EagerSecurityContext.instance.isProactiveAuthDisabled) {
                    ((CurrentIdentityAssociation)EagerSecurityContext.instance.identityAssociation.get()).setIdentity(securityIdentity);
                }
                if (check.requiresMethodArguments()) {
                    if (securityIdentity == null || securityIdentity.isAnonymous()) {
                        UnauthorizedException unauthorizedException = new UnauthorizedException();
                        if (EagerSecurityContext.instance.eventHelper.fireEventOnFailure()) {
                            EagerSecurityContext.instance.eventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(securityIdentity, (Throwable)unauthorizedException, check.getClass().getName(), EagerSecurityContext.createEventPropsWithRoutingCtx(requestContext), invokedMethodDesc));
                        }
                        throw unauthorizedException;
                    }
                    return Uni.createFrom().nullItem();
                }
                return EagerSecurityContext.instance.runSecurityCheck(check, invokedMethodDesc, requestContext, securityIdentity);
            }
        };
    }

    private static boolean isRequestAlreadyChecked(ResteasyReactiveRequestContext requestContext) {
        return requestContext.getProperty(StandardSecurityCheckInterceptor.STANDARD_SECURITY_CHECK_INTERCEPTOR) != null;
    }

    public static final class HttpPermissionsAndSecurityChecksCustomizer
    implements HandlerChainCustomizer {
        private volatile SecurityCheckInfo securityCheckInfo;

        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod serverResourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_MATCH) {
                SecurityCheckInfo info = this.getSecurityCheckInfo(serverResourceMethod);
                return List.of(new EagerSecurityHandler(info.check, info.isDefaultJaxRsSecCheck, info.invokedMethodDesc));
            }
            if (phase == HandlerChainCustomizer.Phase.BEFORE_METHOD_INVOKE && this.requiresMethodArguments(serverResourceMethod)) {
                SecurityCheckInfo info = this.getSecurityCheckInfo(serverResourceMethod);
                if (info.isDefaultJaxRsSecCheck) {
                    throw new IllegalStateException("Registering default SecurityCheck that requires secured method arguments is not supported");
                }
                return List.of(new SecurityCheckWithMethodArgsHandler(info.check, info.invokedMethodDesc));
            }
            return List.of();
        }

        private boolean requiresMethodArguments(ServerResourceMethod serverResourceMethod) {
            return this.getSecurityCheckInfo((ServerResourceMethod)serverResourceMethod).check.requiresMethodArguments();
        }

        private SecurityCheckInfo getSecurityCheckInfo(ServerResourceMethod serverResourceMethod) {
            if (this.securityCheckInfo == null) {
                boolean isDefaultJaxRsSecCheck = false;
                ResourceMethodDescription desc = ResourceMethodDescription.of(serverResourceMethod);
                SecurityCheckStorage checkStorage = (SecurityCheckStorage)Arc.container().instance(SecurityCheckStorage.class, new Annotation[0]).get();
                SecurityCheck check = checkStorage.getSecurityCheck(desc.invokedMethodDesc());
                if (check == null && desc.fallbackMethodDesc() != null) {
                    check = checkStorage.getSecurityCheck(desc.fallbackMethodDesc());
                }
                if (check == null) {
                    check = checkStorage.getDefaultSecurityCheck();
                    isDefaultJaxRsSecCheck = true;
                }
                if (check == null) {
                    throw new IllegalStateException("Security annotation placed on resource method '%s#%s' wasn't detected by Quarkus during the build time.\nPlease consult https://quarkus.io/guides/cdi-reference#bean_discovery on how to make the module containing the code discoverable by Quarkus.\n".formatted(desc.invokedMethodDesc().getClassName(), desc.invokedMethodDesc().getMethodName()));
                }
                this.securityCheckInfo = new SecurityCheckInfo(check, isDefaultJaxRsSecCheck, desc.invokedMethodDesc());
            }
            return this.securityCheckInfo;
        }

        private record SecurityCheckInfo(SecurityCheck check, boolean isDefaultJaxRsSecCheck, MethodDescription invokedMethodDesc) {
        }
    }

    public static final class AuthZPolicyCustomizer
    implements HandlerChainCustomizer {
        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod serverResourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_MATCH) {
                MethodDescription securedMethod;
                ResourceMethodDescription desc = ResourceMethodDescription.of(serverResourceMethod);
                AuthorizationPolicyStorage authorizationPolicyStorage = (AuthorizationPolicyStorage)Arc.container().select(AuthorizationPolicyStorage.class, new Annotation[0]).get();
                if (authorizationPolicyStorage.requiresAuthorizationPolicy(desc.invokedMethodDesc())) {
                    securedMethod = desc.invokedMethodDesc();
                } else if (authorizationPolicyStorage.requiresAuthorizationPolicy(desc.fallbackMethodDesc())) {
                    securedMethod = desc.fallbackMethodDesc();
                } else {
                    throw new IllegalStateException("@AuthorizationPolicy annotation placed on resource method '%s#%s' wasn't detected by Quarkus during the build time.\nPlease consult https://quarkus.io/guides/cdi-reference#bean_discovery on how to make the module containing the code discoverable by Quarkus.\n".formatted(desc.invokedMethodDesc().getClassName(), desc.invokedMethodDesc().getMethodName()));
                }
                return List.of(new EagerSecurityHandler(null, false, securedMethod));
            }
            return List.of();
        }
    }

    public static final class HttpPermissionsOnlyCustomizer
    implements HandlerChainCustomizer {
        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod resourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_MATCH) {
                return List.of(HTTP_PERMS_ONLY);
            }
            return List.of();
        }
    }
}

