/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.arc.InjectableInstance;
import io.quarkus.resteasy.reactive.server.runtime.StandardSecurityCheckInterceptor;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.JaxRsPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;

@Singleton
public class EagerSecurityContext {
    static EagerSecurityContext instance = null;
    private final JaxRsPathMatchingHttpSecurityPolicy jaxRsPathMatchingPolicy;
    final SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> eventHelper;
    final InjectableInstance<CurrentIdentityAssociation> identityAssociation;
    final AuthorizationController authorizationController;
    final boolean doNotRunPermissionSecurityCheck;
    final boolean isProactiveAuthDisabled;

    EagerSecurityContext(Event<AuthorizationFailureEvent> authorizationFailureEvent, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled, Event<AuthorizationSuccessEvent> authorizationSuccessEvent, BeanManager beanManager, InjectableInstance<CurrentIdentityAssociation> identityAssociation, AuthorizationController authorizationController, VertxHttpBuildTimeConfig httpBuildTimeConfig, JaxRsPathMatchingHttpSecurityPolicy jaxRsPathMatchingPolicy) {
        this.isProactiveAuthDisabled = !httpBuildTimeConfig.auth().proactive();
        this.identityAssociation = identityAssociation;
        this.authorizationController = authorizationController;
        this.eventHelper = new SecurityEventHelper(authorizationSuccessEvent, authorizationFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_FAILURE, beanManager, securityEventsEnabled);
        if (jaxRsPathMatchingPolicy.hasNoPermissions()) {
            this.jaxRsPathMatchingPolicy = null;
            this.doNotRunPermissionSecurityCheck = true;
        } else {
            this.jaxRsPathMatchingPolicy = jaxRsPathMatchingPolicy;
            this.doNotRunPermissionSecurityCheck = false;
        }
    }

    void initSingleton(@Observes StartupEvent event) {
        instance = this;
    }

    void destroySingleton(@Observes ShutdownEvent event) {
        instance = null;
    }

    Uni<SecurityIdentity> getDeferredIdentity() {
        return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> get() {
                return ((CurrentIdentityAssociation)EagerSecurityContext.this.identityAssociation.get()).getDeferredIdentity();
            }
        });
    }

    Uni<SecurityIdentity> getPermissionCheck(ResteasyReactiveRequestContext requestContext, final SecurityIdentity identity, MethodDescription invokedMethodDesc) {
        final RoutingContext routingContext = (RoutingContext)requestContext.unwrap(RoutingContext.class);
        if (routingContext == null) {
            throw new IllegalStateException("HTTP Security policy applied only on Quarkus REST cannot be run as 'RoutingContext' is null");
        }
        return this.jaxRsPathMatchingPolicy.checkPermission(routingContext, identity == null ? this.getDeferredIdentity() : Uni.createFrom().item((Object)identity), invokedMethodDesc).flatMap((Function)new Function<HttpSecurityPolicy.CheckResult, Uni<? extends 1SecurityCheckWithIdentity>>(){

            @Override
            public Uni<1SecurityCheckWithIdentity> apply(final HttpSecurityPolicy.CheckResult checkResult) {
                record SecurityCheckWithIdentity(SecurityIdentity identity, HttpSecurityPolicy.CheckResult checkResult) {
                }
                if (identity != null) {
                    return Uni.createFrom().item((Object)new SecurityCheckWithIdentity(identity, checkResult));
                }
                if (checkResult.isPermitted() && checkResult.getAugmentedIdentity() == null) {
                    return Uni.createFrom().item((Object)new SecurityCheckWithIdentity(null, checkResult));
                }
                return EagerSecurityContext.this.getDeferredIdentity().map((Function)new Function<SecurityIdentity, SecurityCheckWithIdentity>(){

                    @Override
                    public SecurityCheckWithIdentity apply(SecurityIdentity identity1) {
                        return new SecurityCheckWithIdentity(identity1, checkResult);
                    }
                });
            }
        }).map((Function)new Function<1SecurityCheckWithIdentity, SecurityIdentity>(){

            @Override
            public SecurityIdentity apply(1SecurityCheckWithIdentity checkWithIdentity) {
                SecurityIdentity newIdentity;
                HttpSecurityPolicy.CheckResult checkResult = checkWithIdentity.checkResult();
                if (checkResult.getAugmentedIdentity() == null) {
                    newIdentity = checkWithIdentity.identity();
                } else if (checkResult.getAugmentedIdentity() != checkWithIdentity.identity()) {
                    newIdentity = checkResult.getAugmentedIdentity();
                    QuarkusHttpUser.setIdentity((SecurityIdentity)newIdentity, (RoutingContext)routingContext);
                    ((CurrentIdentityAssociation)EagerSecurityContext.this.identityAssociation.get()).setIdentity(newIdentity);
                } else {
                    newIdentity = checkResult.getAugmentedIdentity();
                }
                if (checkResult.isPermitted()) {
                    if (EagerSecurityContext.this.eventHelper.fireEventOnSuccess()) {
                        EagerSecurityContext.this.eventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(newIdentity, AbstractPathMatchingHttpSecurityPolicy.class.getName(), Map.of(RoutingContext.class.getName(), routingContext)));
                    }
                    return newIdentity;
                }
                Object exception = newIdentity.isAnonymous() ? new UnauthorizedException() : new ForbiddenException();
                if (EagerSecurityContext.this.eventHelper.fireEventOnFailure()) {
                    EagerSecurityContext.this.eventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(newIdentity, (Throwable)exception, AbstractPathMatchingHttpSecurityPolicy.class.getName(), Map.of(RoutingContext.class.getName(), routingContext)));
                }
                throw exception;
            }
        });
    }

    Uni<?> runSecurityCheck(final SecurityCheck check, final MethodDescription invokedMethodDesc, final ResteasyReactiveRequestContext requestContext, final SecurityIdentity securityIdentity) {
        EagerSecurityContext.preventRepeatedSecurityChecks(requestContext, invokedMethodDesc);
        Uni checkResult = check.nonBlockingApply(securityIdentity, invokedMethodDesc, requestContext.getParameters());
        if (this.eventHelper.fireEventOnFailure()) {
            checkResult = checkResult.onFailure().invoke((Consumer)new Consumer<Throwable>(){

                @Override
                public void accept(Throwable throwable) {
                    EagerSecurityContext.this.eventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(securityIdentity, throwable, check.getClass().getName(), EagerSecurityContext.createEventPropsWithRoutingCtx(requestContext), invokedMethodDesc));
                }
            });
        }
        if (this.eventHelper.fireEventOnSuccess()) {
            checkResult = checkResult.invoke(new Runnable(){

                @Override
                public void run() {
                    EagerSecurityContext.this.eventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(securityIdentity, check.getClass().getName(), EagerSecurityContext.createEventPropsWithRoutingCtx(requestContext), invokedMethodDesc));
                }
            });
        }
        return checkResult;
    }

    static void preventRepeatedSecurityChecks(ResteasyReactiveRequestContext requestContext, MethodDescription methodDescription) {
        requestContext.setProperty(StandardSecurityCheckInterceptor.STANDARD_SECURITY_CHECK_INTERCEPTOR, (Object)methodDescription);
    }

    static Map<String, Object> createEventPropsWithRoutingCtx(ResteasyReactiveRequestContext requestContext) {
        RoutingContext routingContext = (RoutingContext)requestContext.unwrap(RoutingContext.class);
        if (routingContext == null) {
            return Map.of();
        }
        return Map.of(RoutingContext.class.getName(), routingContext);
    }
}

