/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveServerRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.spi.DefaultRuntimeConfiguration;
import org.jboss.resteasy.reactive.server.spi.GenericRuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfiguration;

@Recorder
public class ResteasyReactiveRuntimeRecorder {
    final VertxHttpConfig httpConfig;

    public ResteasyReactiveRuntimeRecorder(VertxHttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public Supplier<RuntimeConfiguration> runtimeConfiguration(RuntimeValue<Deployment> deployment, ResteasyReactiveServerRuntimeConfig runtimeConf) {
        Optional<Object> maxBodySize = this.httpConfig.limits().maxBodySize().isPresent() ? Optional.of(((MemorySize)this.httpConfig.limits().maxBodySize().get()).asLongValue()) : Optional.empty();
        DefaultRuntimeConfiguration runtimeConfiguration = new DefaultRuntimeConfiguration(this.httpConfig.readTimeout(), this.httpConfig.body().deleteUploadedFilesOnEnd(), this.httpConfig.body().uploadsDirectory(), (List)this.httpConfig.body().multipart().fileContentTypes().orElse(null), runtimeConf.multipart().inputPart().defaultCharset(), maxBodySize, this.httpConfig.limits().maxFormAttributeSize().asLongValue(), this.httpConfig.limits().maxParameters());
        ((Deployment)deployment.getValue()).setRuntimeConfiguration((RuntimeConfiguration)runtimeConfiguration);
        return new Supplier<RuntimeConfiguration>((RuntimeConfiguration)runtimeConfiguration){
            final /* synthetic */ RuntimeConfiguration val$runtimeConfiguration;
            {
                this.val$runtimeConfiguration = runtimeConfiguration;
            }

            @Override
            public RuntimeConfiguration get() {
                return this.val$runtimeConfiguration;
            }
        };
    }

    public void configureHandlers(RuntimeValue<Deployment> deployment, Map<Class<?>, Supplier<?>> runtimeConfigMap) {
        List runtimeConfigurableServerRestHandlers = ((Deployment)deployment.getValue()).getRuntimeConfigurableServerRestHandlers();
        for (int i = 0; i < runtimeConfigurableServerRestHandlers.size(); ++i) {
            GenericRuntimeConfigurableServerRestHandler handler = (GenericRuntimeConfigurableServerRestHandler)runtimeConfigurableServerRestHandlers.get(i);
            Supplier<?> supplier = runtimeConfigMap.get(handler.getConfigurationClass());
            if (supplier == null) {
                throw new IllegalStateException("Handler '" + handler.getClass().getName() + "' has not been properly configured.");
            }
            handler.configure(supplier.get());
        }
    }
}

