/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.deployment;

import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.InterceptorResolverBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.restclient.NoopHostnameVerifier;
import io.quarkus.restclient.config.RestClientsConfig;
import io.quarkus.restclient.config.deployment.RestClientConfigUtils;
import io.quarkus.restclient.deployment.IgnoreClientProviderBuildItem;
import io.quarkus.restclient.deployment.RestClientAnnotationProviderBuildItem;
import io.quarkus.restclient.deployment.RestClientPredicateProviderBuildItem;
import io.quarkus.restclient.runtime.PathFeatureHandler;
import io.quarkus.restclient.runtime.PathTemplateInjectionFilter;
import io.quarkus.restclient.runtime.RestClientBase;
import io.quarkus.restclient.runtime.RestClientRecorder;
import io.quarkus.resteasy.common.deployment.JaxrsProvidersToRegisterBuildItem;
import io.quarkus.resteasy.common.deployment.RestClientBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.sse.SseEventSource;
import java.io.Closeable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProviders;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ProxyBuilderImpl;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ResteasyClientProxy;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.microprofile.client.DefaultResponseExceptionMapper;
import org.jboss.resteasy.microprofile.client.RestClientProxy;
import org.jboss.resteasy.microprofile.client.async.AsyncInterceptorRxInvokerProvider;
import org.jboss.resteasy.microprofile.client.publisher.MpPublisherMessageBodyReader;
import org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceImpl;
import org.jboss.resteasy.spi.ResteasyConfiguration;

class RestClientProcessor {
    private static final Logger log = Logger.getLogger(RestClientProcessor.class);
    private static final DotName REST_CLIENT = DotName.createSimple((String)RestClient.class.getName());
    private static final DotName REGISTER_REST_CLIENT = DotName.createSimple((String)RegisterRestClient.class.getName());
    private static final DotName SESSION_SCOPED = DotName.createSimple((String)SessionScoped.class.getName());
    private static final DotName PATH = DotName.createSimple((String)Path.class.getName());
    private static final DotName REGISTER_PROVIDER = DotName.createSimple((String)RegisterProvider.class.getName());
    private static final DotName REGISTER_PROVIDERS = DotName.createSimple((String)RegisterProviders.class.getName());
    private static final DotName REGISTER_CLIENT_HEADERS = DotName.createSimple((String)RegisterClientHeaders.class.getName());
    private static final DotName CLIENT_REQUEST_FILTER = DotName.createSimple((String)ClientRequestFilter.class.getName());
    private static final DotName CLIENT_RESPONSE_FILTER = DotName.createSimple((String)ClientResponseFilter.class.getName());
    private static final DotName CLIENT_HEADER_PARAM = DotName.createSimple((String)ClientHeaderParam.class.getName());
    private static final String PROVIDERS_SERVICE_FILE = "META-INF/services/" + Providers.class.getName();

    RestClientProcessor() {
    }

    @BuildStep
    void setupProviders(BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition) {
        proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"jakarta.ws.rs.ext.Providers"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{PROVIDERS_SERVICE_FILE}));
    }

    @BuildStep
    void setupClientBuilder(BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<ServiceProviderBuildItem> serviceProviders) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/jakarta.ws.rs.client.ClientBuilder"}));
        serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(SseEventSource.Builder.class.getName(), new String[]{SseEventSourceImpl.SourceBuilder.class.getName()}));
    }

    @BuildStep
    NativeImageProxyDefinitionBuildItem addProxy() {
        return new NativeImageProxyDefinitionBuildItem(new String[]{ResteasyConfiguration.class.getName()});
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setup(BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, RestClientRecorder restClientRecorder) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY_CLIENT));
        restClientRecorder.setRestClientBuilderResolver();
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{RestClient.class}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{DefaultResponseExceptionMapper.class.getName(), AsyncInterceptorRxInvokerProvider.class.getName(), ResteasyProviderFactoryImpl.class.getName(), ProxyBuilderImpl.class.getName(), ClientRequestFilter[].class.getName(), ClientResponseFilter[].class.getName(), ReaderInterceptor[].class.getName()}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ResteasyClientBuilder.class.getName(), NoopHostnameVerifier.class.getName()}).methods().build());
    }

    @BuildStep
    UnremovableBeanBuildItem makeConfigUnremovable() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{RestClientsConfig.class});
    }

    @BuildStep
    List<RestClientPredicateProviderBuildItem> transformAnnotationProvider(List<RestClientAnnotationProviderBuildItem> annotationProviders) {
        ArrayList<RestClientPredicateProviderBuildItem> result = new ArrayList<RestClientPredicateProviderBuildItem>();
        for (final RestClientAnnotationProviderBuildItem annotationProvider : annotationProviders) {
            result.add(new RestClientPredicateProviderBuildItem(annotationProvider.getProviderClass().getName(), new Predicate<ClassInfo>(){

                @Override
                public boolean test(ClassInfo classInfo) {
                    return classInfo.hasAnnotation(annotationProvider.getAnnotationName());
                }
            }));
        }
        return result;
    }

    @BuildStep
    void processInterfaces(CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability, NativeConfig nativeConfig, List<RestClientPredicateProviderBuildItem> restClientProviders, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<RestClientBuildItem> restClient) {
        HashMap<DotName, ClassInfo> interfaces = new HashMap<DotName, ClassInfo>();
        HashSet<Type> returnTypes = new HashSet<Type>();
        CompositeIndex index = CompositeIndex.create((IndexView[])new IndexView[]{beanArchiveIndexBuildItem.getIndex(), combinedIndexBuildItem.getIndex()});
        this.findInterfaces((IndexView)index, interfaces, returnTypes, REGISTER_REST_CLIENT);
        this.findInterfaces((IndexView)index, interfaces, returnTypes, PATH);
        if (interfaces.isEmpty()) {
            return;
        }
        for (DotName dotName : interfaces.keySet()) {
            restClient.produce((BuildItem)new RestClientBuildItem(dotName.toString()));
        }
        this.warnAboutNotWorkingFeaturesInNative(nativeConfig, interfaces);
        for (Map.Entry entry : interfaces.entrySet()) {
            String string = ((DotName)entry.getKey()).toString();
            proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{string, ResteasyClientProxy.class.getName()}));
            proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{string, RestClientProxy.class.getName(), Closeable.class.getName()}));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{string}).methods().build());
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{DefaultClientHeadersFactoryImpl.class.getName()}).methods().build());
        for (Type type : returnTypes) {
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(type).ignoreTypePredicate((Predicate)ResteasyDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ResteasyDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ResteasyDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(this.getClass().getSimpleName() + " > " + type.toString()).build());
        }
        Config config = ConfigProvider.getConfig();
        for (Map.Entry<DotName, ClassInfo> entry : interfaces.entrySet()) {
            DotName restClientName = (DotName)entry.getKey();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = SyntheticBeanBuildItem.configure((DotName)restClientName);
            configurator.addType(restClientName);
            configurator.addQualifier(REST_CLIENT);
            Optional<String> configKey = this.getConfigKey((ClassInfo)entry.getValue());
            ScopeInfo scope = this.computeDefaultScope(capabilities, config, entry, configKey);
            List<String> clientProviders = RestClientProcessor.checkRestClientProviders(entry.getValue(), restClientProviders);
            configurator.scope(scope);
            configurator.creator(m -> {
                ResultHandle restClientProvidersHandle;
                ResultHandle configKeyHandle;
                ResultHandle interfaceHandle = m.loadClassFromTCCL(restClientName.toString());
                ResultHandle baseUriHandle = m.load(this.getAnnotationParameter((ClassInfo)entry.getValue(), "baseUri"));
                ResultHandle resultHandle = configKeyHandle = configKey.isPresent() ? m.load((String)configKey.get()) : m.loadNull();
                if (!clientProviders.isEmpty()) {
                    restClientProvidersHandle = m.newArray(Class.class, clientProviders.size());
                    for (int i = 0; i < clientProviders.size(); ++i) {
                        m.writeArrayValue(restClientProvidersHandle, i, m.loadClassFromTCCL((String)clientProviders.get(i)));
                    }
                } else {
                    restClientProvidersHandle = m.loadNull();
                }
                ResultHandle baseHandle = m.newInstance(MethodDescriptor.ofConstructor(RestClientBase.class, (Class[])new Class[]{Class.class, String.class, String.class, Class[].class}), new ResultHandle[]{interfaceHandle, baseUriHandle, configKeyHandle, restClientProvidersHandle});
                ResultHandle ret = m.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"create", Object.class, (Class[])new Class[0]), baseHandle, new ResultHandle[0]);
                m.returnValue(ret);
            });
            configurator.destroyer(BeanDestroyer.CloseableDestroyer.class);
            syntheticBeans.produce((BuildItem)configurator.done());
        }
    }

    @BuildStep
    void clientTracingFeature(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<ResteasyJaxrsProviderBuildItem> producer) {
        if (this.isRequired(capabilities, metricsCapability)) {
            producer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(PathFeatureHandler.class.getName()));
            producer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(PathTemplateInjectionFilter.class.getName()));
        }
    }

    private boolean isRequired(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        return capabilities.isPresent("io.quarkus.opentelemetry.tracer") || metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer");
    }

    private static List<String> checkRestClientProviders(ClassInfo classInfo, List<RestClientPredicateProviderBuildItem> restClientProviders) {
        return restClientProviders.stream().filter(p -> p.appliesTo(classInfo)).map(p -> p.getProviderClass()).collect(Collectors.toList());
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.RESTEASY_CLIENT);
    }

    private void warnAboutNotWorkingFeaturesInNative(NativeConfig nativeConfig, Map<DotName, ClassInfo> interfaces) {
        if (!nativeConfig.enabled()) {
            return;
        }
        HashSet<DotName> dotNames = new HashSet<DotName>();
        for (ClassInfo interfaze : interfaces.values()) {
            if (interfaze.declaredAnnotation(CLIENT_HEADER_PARAM) == null) continue;
            boolean hasDefault = false;
            for (MethodInfo method : interfaze.methods()) {
                if (!RestClientProcessor.isDefault(method.flags())) continue;
                hasDefault = true;
                break;
            }
            if (!hasDefault) continue;
            dotNames.add(interfaze.name());
        }
        if (!dotNames.isEmpty()) {
            log.warnf("rest-client interfaces that contain default methods and are annotated with '@" + CLIENT_HEADER_PARAM + "' might not work properly in native mode. Offending interfaces are: " + dotNames.stream().map(d -> "'" + d.toString() + "'").collect(Collectors.joining(", ")), new Object[0]);
        }
    }

    private static boolean isDefault(short flags) {
        return (flags & 0x409) == 1;
    }

    private void findInterfaces(IndexView index, Map<DotName, ClassInfo> interfaces, Set<Type> returnTypes, DotName annotationToFind) {
        for (AnnotationInstance annotation : index.getAnnotations(annotationToFind)) {
            ClassInfo theInfo;
            AnnotationTarget target = annotation.target();
            if (target.kind() == AnnotationTarget.Kind.CLASS) {
                theInfo = target.asClass();
            } else {
                if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
                theInfo = target.asMethod().declaringClass();
            }
            if (!this.isRestClientInterface(index, theInfo)) continue;
            interfaces.put(theInfo.name(), theInfo);
            this.processInterfaceReturnTypes(theInfo, returnTypes);
            for (Type interfaceType : theInfo.interfaceTypes()) {
                ClassInfo interfaceClassInfo = index.getClassByName(interfaceType.name());
                if (interfaceClassInfo == null) continue;
                this.processInterfaceReturnTypes(interfaceClassInfo, returnTypes);
            }
        }
    }

    private void processInterfaceReturnTypes(ClassInfo classInfo, Set<Type> returnTypes) {
        for (MethodInfo method : classInfo.methods()) {
            Type type = method.returnType();
            if (type.name().toString().startsWith("java.lang")) continue;
            returnTypes.add(type);
        }
    }

    private Optional<String> getConfigKey(ClassInfo classInfo) {
        String configKey = this.getAnnotationParameter(classInfo, "configKey");
        if (configKey.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(configKey);
    }

    private ScopeInfo computeDefaultScope(Capabilities capabilities, Config config, Map.Entry<DotName, ClassInfo> entry, Optional<String> configKey) {
        BuiltinScope globalDefaultScope;
        ScopeInfo scopeToUse;
        block9: {
            ClassInfo classInfo;
            block8: {
                scopeToUse = null;
                classInfo = entry.getValue();
                Optional scopeConfig = RestClientConfigUtils.findConfiguredScope((Config)config, (ClassInfo)classInfo, configKey);
                Optional configuredGlobalDefaultScope = RestClientConfigUtils.getDefaultScope((Config)config);
                if (configuredGlobalDefaultScope.isPresent()) {
                    globalDefaultScope = RestClientProcessor.builtinScopeFromName(DotName.createSimple((String)((String)configuredGlobalDefaultScope.get())));
                    if (globalDefaultScope == null) {
                        log.warnf("Unable to map the global REST client scope: '%s' to a scope. Using @Dependent", configuredGlobalDefaultScope.get());
                        globalDefaultScope = BuiltinScope.DEPENDENT;
                    }
                } else {
                    globalDefaultScope = BuiltinScope.DEPENDENT;
                }
                if (!scopeConfig.isPresent()) break block8;
                DotName scope = DotName.createSimple((String)((String)scopeConfig.get()));
                BuiltinScope builtinScope = RestClientProcessor.builtinScopeFromName(scope);
                if (builtinScope != null) {
                    scopeToUse = builtinScope.getInfo();
                } else if (capabilities.isPresent("io.quarkus.servlet") && (scope.equals((Object)SESSION_SCOPED) || scope.toString().equalsIgnoreCase(SESSION_SCOPED.withoutPackagePrefix()))) {
                    scopeToUse = new ScopeInfo(SESSION_SCOPED, true);
                }
                if (scopeToUse != null) break block9;
                log.warn((Object)String.format("Unsupported default scope %s provided for REST client %s. Defaulting to @Dependent.", scope, entry.getKey()));
                break block9;
            }
            Set annotations = classInfo.annotationsMap().keySet();
            for (DotName annotationName : annotations) {
                BuiltinScope builtinScope = BuiltinScope.from((DotName)annotationName);
                if (builtinScope != null) {
                    scopeToUse = builtinScope.getInfo();
                    break;
                }
                if (!annotationName.equals((Object)SESSION_SCOPED)) continue;
                scopeToUse = new ScopeInfo(SESSION_SCOPED, true);
                break;
            }
        }
        return scopeToUse != null ? scopeToUse : globalDefaultScope.getInfo();
    }

    private String getAnnotationParameter(ClassInfo classInfo, String parameterName) {
        AnnotationInstance instance = classInfo.declaredAnnotation(REGISTER_REST_CLIENT);
        if (instance == null) {
            return "";
        }
        AnnotationValue value = instance.value(parameterName);
        if (value == null) {
            return "";
        }
        return value.asString();
    }

    @BuildStep
    IgnoreClientProviderBuildItem ignoreMPPublisher() {
        return new IgnoreClientProviderBuildItem(MpPublisherMessageBodyReader.class.getName());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem, List<IgnoreClientProviderBuildItem> ignoreClientProviderBuildItems, CombinedIndexBuildItem combinedIndexBuildItem, ResteasyInjectionReadyBuildItem injectorFactory, RestClientRecorder restClientRecorder, Capabilities capabilities) {
        for (IgnoreClientProviderBuildItem item : ignoreClientProviderBuildItems) {
            jaxrsProvidersToRegisterBuildItem.getProviders().remove(item.getProviderClassName());
            jaxrsProvidersToRegisterBuildItem.getContributedProviders().remove(item.getProviderClassName());
        }
        restClientRecorder.initializeResteasyProviderFactory(injectorFactory.getInjectorFactory(), jaxrsProvidersToRegisterBuildItem.useBuiltIn(), jaxrsProvidersToRegisterBuildItem.getProviders(), jaxrsProvidersToRegisterBuildItem.getContributedProviders());
        if (!capabilities.isPresent("io.quarkus.resteasy") && !capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            restClientRecorder.setResteasyProviderFactoryInstance();
        }
        for (String providerToRegister : jaxrsProvidersToRegisterBuildItem.getProviders()) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{providerToRegister}).build());
        }
        IndexView index = combinedIndexBuildItem.getIndex();
        ArrayList<AnnotationInstance> allInstances = new ArrayList<AnnotationInstance>(index.getAnnotations(REGISTER_PROVIDER));
        for (AnnotationInstance annotation : index.getAnnotations(REGISTER_PROVIDERS)) {
            allInstances.addAll(Arrays.asList(annotation.value().asNestedArray()));
        }
        for (AnnotationInstance annotationInstance : allInstances) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{annotationInstance.value().asClass().toString()}).build());
        }
        for (AnnotationInstance annotationInstance : index.getAnnotations(REGISTER_CLIENT_HEADERS)) {
            AnnotationValue value = annotationInstance.value();
            if (value == null) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{annotationInstance.value().asClass().toString()}).build());
        }
        for (ClassInfo info : index.getAllKnownImplementors(CLIENT_REQUEST_FILTER)) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{info.name().toString()}).build());
        }
        for (ClassInfo info : index.getAllKnownImplementors(CLIENT_RESPONSE_FILTER)) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{info.name().toString()}).build());
        }
    }

    @BuildStep
    AdditionalBeanBuildItem registerProviderBeans(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        ArrayList<AnnotationInstance> allInstances = new ArrayList<AnnotationInstance>(index.getAnnotations(REGISTER_PROVIDER));
        for (AnnotationInstance annotation : index.getAnnotations(REGISTER_PROVIDERS)) {
            allInstances.addAll(Arrays.asList(annotation.value().asNestedArray()));
        }
        allInstances.addAll(index.getAnnotations(REGISTER_CLIENT_HEADERS));
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        for (AnnotationInstance annotationInstance : allInstances) {
            AnnotationValue value = annotationInstance.value();
            if (value == null) continue;
            builder.addBeanClass(value.asClass().toString());
        }
        return builder.build();
    }

    @BuildStep
    void unremovableInterceptors(List<RestClientBuildItem> restClientInterfaces, BeanArchiveIndexBuildItem beanArchiveIndex, InterceptorResolverBuildItem interceptorResolver, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        if (restClientInterfaces.isEmpty()) {
            return;
        }
        IndexView index = beanArchiveIndex.getIndex();
        Set interceptorBindings = interceptorResolver.getInterceptorBindings();
        HashSet unremovableInterceptors = new HashSet();
        for (RestClientBuildItem restClient : restClientInterfaces) {
            ClassInfo restClientClass = index.getClassByName(DotName.createSimple((String)restClient.getInterfaceName()));
            if (restClientClass == null) continue;
            HashSet<AnnotationInstance> classLevelBindings = new HashSet<AnnotationInstance>();
            for (AnnotationInstance annotationInstance : restClientClass.declaredAnnotations()) {
                if (!interceptorBindings.contains(annotationInstance.name())) continue;
                classLevelBindings.add(annotationInstance);
            }
            for (MethodInfo method : restClientClass.methods()) {
                List interceptors;
                if (Modifier.isStatic(method.flags())) continue;
                HashSet<AnnotationInstance> bindings = new HashSet<AnnotationInstance>(classLevelBindings);
                for (AnnotationInstance annotationInstance : method.annotations()) {
                    if (annotationInstance.target().kind() != AnnotationTarget.Kind.METHOD || !interceptorBindings.contains(annotationInstance.name())) continue;
                    bindings.add(annotationInstance);
                }
                if (bindings.isEmpty() || (interceptors = interceptorResolver.get().resolve(InterceptionType.AROUND_INVOKE, bindings)).isEmpty()) continue;
                interceptors.stream().map(BeanInfo::getBeanClass).map(Object::toString).forEach(unremovableInterceptors::add);
            }
        }
        if (!unremovableInterceptors.isEmpty()) {
            unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames(unremovableInterceptors));
        }
    }

    private boolean isRestClientInterface(IndexView index, ClassInfo classInfo) {
        return Modifier.isInterface(classInfo.flags()) && index.getAllKnownImplementors(classInfo.name()).isEmpty();
    }

    private static BuiltinScope builtinScopeFromName(DotName scopeName) {
        BuiltinScope scope = BuiltinScope.from((DotName)scopeName);
        if (scope == null) {
            for (BuiltinScope builtinScope : BuiltinScope.values()) {
                if (!builtinScope.getName().withoutPackagePrefix().equalsIgnoreCase(scopeName.toString())) continue;
                scope = builtinScope;
            }
        }
        return scope;
    }
}

