/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.oidc.client.deployment.AccessTokenInstanceBuildItem;
import io.quarkus.oidc.client.deployment.AccessTokenRequestFilterGenerator;
import io.quarkus.oidc.token.propagation.AccessTokenRequestFilter;
import io.quarkus.oidc.token.propagation.JsonWebToken;
import io.quarkus.oidc.token.propagation.JsonWebTokenRequestFilter;
import io.quarkus.oidc.token.propagation.runtime.OidcTokenPropagationBuildTimeConfig;
import io.quarkus.oidc.token.propagation.runtime.OidcTokenPropagationConfig;
import io.quarkus.restclient.deployment.RestClientAnnotationProviderBuildItem;
import io.quarkus.restclient.deployment.RestClientPredicateProviderBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.DotName;

@BuildSteps(onlyIf={IsEnabled.class})
public class OidcTokenPropagationBuildStep {
    private static final DotName JWT_ACCESS_TOKEN_CREDENTIAL = DotName.createSimple((String)JsonWebToken.class.getName());
    OidcTokenPropagationConfig config;

    @BuildStep
    void registerProvider(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProviders, BuildProducer<RestClientPredicateProviderBuildItem> providerPredicateProducer, BuildProducer<GeneratedBeanBuildItem> generatedBeanProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeanProducer, List<AccessTokenInstanceBuildItem> accessTokenInstances, BuildProducer<RestClientAnnotationProviderBuildItem> restAnnotationProvider) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(AccessTokenRequestFilter.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(JsonWebTokenRequestFilter.class));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{AccessTokenRequestFilter.class}).methods().fields().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{JsonWebTokenRequestFilter.class}).methods().fields().build());
        if (this.config.registerFilter()) {
            Class filterClass = this.config.jsonWebToken() ? JsonWebTokenRequestFilter.class : AccessTokenRequestFilter.class;
            jaxrsProviders.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(filterClass.getName()));
        } else {
            restAnnotationProvider.produce((BuildItem)new RestClientAnnotationProviderBuildItem(JWT_ACCESS_TOKEN_CREDENTIAL, JsonWebTokenRequestFilter.class));
            if (!accessTokenInstances.isEmpty()) {
                AccessTokenRequestFilterGenerator filterGenerator = new AccessTokenRequestFilterGenerator(unremovableBeanProducer, reflectiveClass, generatedBeanProducer, AccessTokenRequestFilter.class);
                for (AccessTokenInstanceBuildItem instance : accessTokenInstances) {
                    String providerClass = filterGenerator.generateClass(instance);
                    providerPredicateProducer.produce((BuildItem)new RestClientPredicateProviderBuildItem(providerClass, ci -> instance.targetClass().equals(ci.name().toString())));
                }
            }
        }
    }

    @BuildStep(onlyIf={IsEnabledDuringAuth.class})
    SystemPropertyBuildItem activateTokenCredentialPropagationViaDuplicatedContext(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.oidc")) {
            return new SystemPropertyBuildItem("io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX", "true");
        }
        if (capabilities.isPresent("io.quarkus.jwt")) {
            return new SystemPropertyBuildItem("io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX", "true");
        }
        throw new ConfigurationException("Configuration property 'quarkus.resteasy-client-oidc-token-propagation.enabled-during-authentication' is set to 'true', however this configuration property is only supported when either 'quarkus-oidc' or 'quarkus-smallrye-jwt' extensions are present.");
    }

    public static class IsEnabledDuringAuth
    implements BooleanSupplier {
        OidcTokenPropagationBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabledDuringAuthentication;
        }
    }

    public static class IsEnabled
    implements BooleanSupplier {
        OidcTokenPropagationBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

