/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.common.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ProxyUnwrapperBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.resteasy.common.deployment.JaxrsProvidersToRegisterBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyDotNames;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.common.runtime.ResteasyInjectorFactoryRecorder;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.MemorySize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.SseElementType;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.plugins.interceptors.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.spi.InjectorFactory;

public class ResteasyCommonProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)ResteasyCommonProcessor.class.getName());
    private static final DotName SSE_ELEMENT_TYPE = DotName.createSimple((String)SseElementType.class.getName());
    private static final ProviderDiscoverer[] PROVIDER_DISCOVERERS = new ProviderDiscoverer[]{new ProviderDiscoverer(ResteasyDotNames.GET, false, true), new ProviderDiscoverer(ResteasyDotNames.HEAD, false, false), new ProviderDiscoverer(ResteasyDotNames.DELETE, true, false), new ProviderDiscoverer(ResteasyDotNames.OPTIONS, false, true), new ProviderDiscoverer(ResteasyDotNames.PATCH, true, false), new ProviderDiscoverer(ResteasyDotNames.POST, true, true), new ProviderDiscoverer(ResteasyDotNames.PUT, true, false)};
    private ResteasyCommonConfig resteasyCommonConfig;

    @BuildStep
    void setupGzipProviders(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        if (this.resteasyCommonConfig.gzip.enabled) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AcceptEncodingGZIPFilter.class.getName()));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(GZIPDecodingInterceptor.class.getName()));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(GZIPEncodingInterceptor.class.getName()));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    ResteasyInjectionReadyBuildItem setupResteasyInjection(List<ProxyUnwrapperBuildItem> proxyUnwrappers, BeanContainerBuildItem beanContainerBuildItem, ResteasyInjectorFactoryRecorder recorder) {
        ArrayList<Function> unwrappers = new ArrayList<Function>();
        for (ProxyUnwrapperBuildItem i : proxyUnwrappers) {
            unwrappers.add(i.getUnwrapper());
        }
        RuntimeValue injectorFactory = recorder.setup(beanContainerBuildItem.getValue(), unwrappers);
        return new ResteasyInjectionReadyBuildItem((RuntimeValue<InjectorFactory>)injectorFactory);
    }

    @BuildStep
    JaxrsProvidersToRegisterBuildItem setupProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem indexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, List<ResteasyJaxrsProviderBuildItem> contributedProviderBuildItems, Capabilities capabilities) throws Exception {
        HashSet<String> contributedProviders = new HashSet<String>();
        for (ResteasyJaxrsProviderBuildItem contributedProviderBuildItem : contributedProviderBuildItems) {
            contributedProviders.add(contributedProviderBuildItem.getName());
        }
        for (AnnotationInstance i : indexBuildItem.getIndex().getAnnotations(ResteasyDotNames.PROVIDER)) {
            if (i.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            contributedProviders.add(i.target().asClass().name().toString());
        }
        Set availableProviders = ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + Providers.class.getName()));
        MediaTypeMap categorizedReaders = new MediaTypeMap();
        MediaTypeMap categorizedWriters = new MediaTypeMap();
        MediaTypeMap categorizedContextResolvers = new MediaTypeMap();
        HashSet<String> otherProviders = new HashSet<String>();
        ResteasyCommonProcessor.categorizeProviders(availableProviders, (MediaTypeMap<String>)categorizedReaders, (MediaTypeMap<String>)categorizedWriters, (MediaTypeMap<String>)categorizedContextResolvers, otherProviders);
        HashSet<String> providersToRegister = new HashSet<String>(otherProviders);
        if (!capabilities.isCapabilityPresent("io.quarkus.resteasy-json")) {
            boolean needJsonSupport;
            boolean bl = needJsonSupport = this.restJsonSupportNeeded(indexBuildItem, ResteasyDotNames.CONSUMES) || this.restJsonSupportNeeded(indexBuildItem, ResteasyDotNames.PRODUCES);
            if (needJsonSupport) {
                LOGGER.warn((Object)"Quarkus detected the need of REST JSON support but you have not provided the necessary JSON extension for this. You can visit https://quarkus.io/guides/rest-json for more information on how to set one.");
            }
        }
        providersToRegister.add(StringTextStar.class.getName());
        providersToRegister.addAll(categorizedWriters.getPossible(MediaType.APPLICATION_JSON_TYPE));
        IndexView index = indexBuildItem.getIndex();
        IndexView beansIndex = beanArchiveIndexBuildItem.getIndex();
        boolean useBuiltinProviders = ResteasyCommonProcessor.collectDeclaredProviders(providersToRegister, (MediaTypeMap<String>)categorizedReaders, (MediaTypeMap<String>)categorizedWriters, (MediaTypeMap<String>)categorizedContextResolvers, index, beansIndex);
        if (useBuiltinProviders) {
            providersToRegister = new HashSet(contributedProviders);
            providersToRegister.addAll(availableProviders);
        } else {
            providersToRegister.addAll(contributedProviders);
        }
        if (providersToRegister.contains("org.jboss.resteasy.plugins.providers.jsonb.JsonBindingProvider")) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.jboss.resteasy.plugins.providers.jsonb.AbstractJsonBindingProvider"}));
        }
        return new JaxrsProvidersToRegisterBuildItem(providersToRegister, contributedProviders, useBuiltinProviders);
    }

    private boolean restJsonSupportNeeded(CombinedIndexBuildItem indexBuildItem, DotName mediaTypeAnnotation) {
        for (AnnotationInstance annotationInstance : indexBuildItem.getIndex().getAnnotations(mediaTypeAnnotation)) {
            AnnotationValue annotationValue = annotationInstance.value();
            if (annotationValue == null) continue;
            List<String> mediaTypes = Arrays.asList(annotationValue.asStringArray());
            return mediaTypes.contains("application/json") || mediaTypes.contains("application/json-patch+json");
        }
        return false;
    }

    public static void categorizeProviders(Set<String> availableProviders, MediaTypeMap<String> categorizedReaders, MediaTypeMap<String> categorizedWriters, MediaTypeMap<String> categorizedContextResolvers, Set<String> otherProviders) {
        for (String availableProvider : availableProviders) {
            try {
                Produces produces;
                Class<?> providerClass = Class.forName(availableProvider);
                if (MessageBodyReader.class.isAssignableFrom(providerClass) || MessageBodyWriter.class.isAssignableFrom(providerClass)) {
                    if (MessageBodyReader.class.isAssignableFrom(providerClass)) {
                        Consumes consumes = providerClass.getAnnotation(Consumes.class);
                        if (consumes != null) {
                            for (String consumesMediaType : consumes.value()) {
                                categorizedReaders.add(MediaType.valueOf((String)consumesMediaType), (Object)providerClass.getName());
                            }
                        } else {
                            categorizedReaders.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                        }
                    }
                    if (!MessageBodyWriter.class.isAssignableFrom(providerClass)) continue;
                    produces = providerClass.getAnnotation(Produces.class);
                    if (produces != null) {
                        for (String producesMediaType : produces.value()) {
                            categorizedWriters.add(MediaType.valueOf((String)producesMediaType), (Object)providerClass.getName());
                        }
                        continue;
                    }
                    categorizedWriters.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                    continue;
                }
                if (ContextResolver.class.isAssignableFrom(providerClass)) {
                    produces = providerClass.getAnnotation(Produces.class);
                    if (produces != null) {
                        for (String producesMediaType : produces.value()) {
                            categorizedContextResolvers.add(MediaType.valueOf((String)producesMediaType), (Object)providerClass.getName());
                        }
                        continue;
                    }
                    categorizedContextResolvers.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                    continue;
                }
                otherProviders.add(providerClass.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private static boolean collectDeclaredProviders(Set<String> providersToRegister, MediaTypeMap<String> categorizedReaders, MediaTypeMap<String> categorizedWriters, MediaTypeMap<String> categorizedContextResolvers, IndexView ... indexes) {
        for (IndexView index : indexes) {
            for (ProviderDiscoverer providerDiscoverer : PROVIDER_DISCOVERERS) {
                Collection getMethods = index.getAnnotations(providerDiscoverer.getMethodAnnotation());
                for (AnnotationInstance getMethod : getMethods) {
                    MethodInfo methodTarget = getMethod.target().asMethod();
                    if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedReaders, methodTarget, ResteasyDotNames.CONSUMES, providerDiscoverer.noConsumesDefaultsToAll())) {
                        return true;
                    }
                    if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedWriters, methodTarget, ResteasyDotNames.PRODUCES, providerDiscoverer.noProducesDefaultsToAll())) {
                        return true;
                    }
                    if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedContextResolvers, methodTarget, ResteasyDotNames.CONSUMES, providerDiscoverer.noConsumesDefaultsToAll())) {
                        return true;
                    }
                    if (!ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedContextResolvers, methodTarget, ResteasyDotNames.PRODUCES, providerDiscoverer.noProducesDefaultsToAll())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean collectDeclaredProvidersForMethodAndMediaTypeAnnotation(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, MethodInfo methodTarget, DotName mediaTypeAnnotation, boolean defaultsToAll) {
        AnnotationInstance mediaTypeAnnotationInstance = methodTarget.annotation(mediaTypeAnnotation);
        if (mediaTypeAnnotationInstance == null) {
            Collection classAnnotations = methodTarget.declaringClass().classAnnotations();
            for (AnnotationInstance classAnnotation : classAnnotations) {
                if (!mediaTypeAnnotation.equals((Object)classAnnotation.name())) continue;
                return ResteasyCommonProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, classAnnotation, methodTarget);
            }
            return defaultsToAll;
        }
        return ResteasyCommonProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, mediaTypeAnnotationInstance, methodTarget);
    }

    private static boolean collectDeclaredProvidersForMediaTypeAnnotationInstance(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, AnnotationInstance mediaTypeAnnotationInstance, MethodInfo targetMethod) {
        for (String media : mediaTypeAnnotationInstance.value().asStringArray()) {
            MediaType mediaType = MediaType.valueOf((String)media);
            if (MediaType.WILDCARD_TYPE.equals((Object)mediaType)) {
                return true;
            }
            providersToRegister.addAll(categorizedProviders.getPossible(mediaType));
            providersToRegister.addAll(ResteasyCommonProcessor.collectInferredProviders(mediaType, categorizedProviders, targetMethod));
        }
        return false;
    }

    private static Collection<String> collectInferredProviders(MediaType mediaType, MediaTypeMap<String> categorizedProviders, MethodInfo targetMethod) {
        if (ResteasyCommonProcessor.matches(MediaType.SERVER_SENT_EVENTS_TYPE, mediaType)) {
            HashSet<String> additionalProvidersToRegister = new HashSet<String>();
            AnnotationInstance sseElementTypeAnnInst = targetMethod.annotation(SSE_ELEMENT_TYPE);
            String elementType = null;
            if (sseElementTypeAnnInst != null) {
                elementType = sseElementTypeAnnInst.value().asString();
            } else if (mediaType.getParameters() != null && mediaType.getParameters().containsKey("element-type")) {
                elementType = (String)mediaType.getParameters().get("element-type");
            }
            if (elementType != null) {
                additionalProvidersToRegister.addAll(categorizedProviders.getPossible(MediaType.valueOf((String)elementType)));
            } else {
                additionalProvidersToRegister.addAll(categorizedProviders.getPossible(MediaType.TEXT_PLAIN_TYPE));
            }
            return additionalProvidersToRegister;
        }
        return Collections.emptySet();
    }

    private static boolean matches(MediaType m1, MediaType m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.getType() == null || m1.getSubtype() == null) {
            return false;
        }
        return m1.getType().equalsIgnoreCase(m2.getType()) && m1.getSubtype().equalsIgnoreCase(m2.getSubtype());
    }

    private static class ProviderDiscoverer {
        private final DotName methodAnnotation;
        private final boolean noConsumesDefaultsToAll;
        private final boolean noProducesDefaultsToAll;

        private ProviderDiscoverer(DotName methodAnnotation, boolean noConsumesDefaultsToAll, boolean noProducesDefaultsToAll) {
            this.methodAnnotation = methodAnnotation;
            this.noConsumesDefaultsToAll = noConsumesDefaultsToAll;
            this.noProducesDefaultsToAll = noProducesDefaultsToAll;
        }

        public DotName getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public boolean noConsumesDefaultsToAll() {
            return this.noConsumesDefaultsToAll;
        }

        public boolean noProducesDefaultsToAll() {
            return this.noProducesDefaultsToAll;
        }
    }

    @ConfigGroup
    public static final class ResteasyCommonConfigGzip {
        @ConfigItem
        public boolean enabled;
        @ConfigItem(defaultValue="10M")
        public MemorySize maxInput;
    }

    @ConfigRoot(name="resteasy")
    public static final class ResteasyCommonConfig {
        public ResteasyCommonConfigGzip gzip;
    }
}

