/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ProxyUnwrapperBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateConfigBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.jaxb.deployment.JaxbEnabledBuildItem;
import io.quarkus.resteasy.common.deployment.JaxrsProvidersToRegisterBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyCommonProcessor;
import io.quarkus.resteasy.common.deployment.ResteasyDotNames;
import io.quarkus.resteasy.common.deployment.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.deployment.ResteasyJaxrsConfig;
import io.quarkus.resteasy.runtime.QuarkusInjectorFactory;
import io.quarkus.resteasy.runtime.ResteasyFilter;
import io.quarkus.resteasy.runtime.ResteasyTemplate;
import io.quarkus.resteasy.runtime.RolesFilterRegistrar;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.servlet.DispatcherType;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ViolationReport;
import org.jboss.resteasy.microprofile.config.FilterConfigSource;
import org.jboss.resteasy.microprofile.config.ServletConfigSource;
import org.jboss.resteasy.microprofile.config.ServletContextConfigSource;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ResteasyScanningProcessor {
    private static final String JAVAX_WS_RS_APPLICATION;
    private static final String JAX_RS_FILTER_NAME;
    private static final String JAX_RS_SERVLET_NAME;
    private static final String JAX_RS_APPLICATION_PARAMETER_NAME = "javax.ws.rs.Application";
    private static final DotName JSONB_ANNOTATION;
    private static final Set<DotName> TYPES_IGNORED_FOR_REFLECTION;
    private static final DotName[] METHOD_ANNOTATIONS;
    private static final DotName[] RESTEASY_PARAM_ANNOTATIONS;
    ResteasyConfig resteasyConfig;
    ResteasyCommonProcessor.ResteasyCommonConfig commonConfig;
    private static final Logger log;

    @BuildStep
    ResteasyJaxrsConfig exportConfig() {
        return new ResteasyJaxrsConfig(this.resteasyConfig.path);
    }

    @BuildStep
    SubstrateConfigBuildItem config() {
        return SubstrateConfigBuildItem.builder().addResourceBundle("messages").build();
    }

    @BuildStep
    public void build(BuildProducer<FeatureBuildItem> feature, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<SubstrateProxyDefinitionBuildItem> proxyDefinition, BuildProducer<SubstrateResourceBuildItem> resource, BuildProducer<RuntimeInitializedClassBuildItem> runtimeClasses, BuildProducer<FilterBuildItem> filterProducer, BuildProducer<ServletBuildItem> servletProducer, BuildProducer<ServletInitParamBuildItem> servletContextParams, BuildProducer<BytecodeTransformerBuildItem> transformers, CombinedIndexBuildItem combinedIndexBuildItem) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("resteasy"));
        IndexView index = combinedIndexBuildItem.getIndex();
        resource.produce((BuildItem)new SubstrateResourceBuildItem(new String[]{"META-INF/services/javax.ws.rs.client.ClientBuilder"}));
        Collection app = index.getAnnotations(ResteasyDotNames.APPLICATION_PATH);
        for (AnnotationInstance annotation : index.getAnnotations(ResteasyDotNames.CONTEXT)) {
            DotName typeName = null;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo method = annotation.target().asMethod();
                if (method.parameters().size() == 1) {
                    typeName = ((Type)method.parameters().get(0)).name();
                }
            } else if (annotation.target().kind() == AnnotationTarget.Kind.FIELD) {
                typeName = annotation.target().asField().type().name();
            } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                short pos = annotation.target().asMethodParameter().position();
                typeName = ((Type)annotation.target().asMethodParameter().method().parameters().get(pos)).name();
            }
            if (typeName == null) continue;
            ClassInfo type = index.getClassByName(typeName);
            if (type != null) {
                if (!Modifier.isInterface(type.flags())) continue;
                proxyDefinition.produce((BuildItem)new SubstrateProxyDefinitionBuildItem(new String[]{type.toString()}));
                continue;
            }
            try {
                Class<?> typeClass = Class.forName(typeName.toString());
                if (!typeClass.isInterface()) continue;
                proxyDefinition.produce((BuildItem)new SubstrateProxyDefinitionBuildItem(new String[]{typeName.toString()}));
            }
            catch (Exception typeClass) {}
        }
        for (ClassInfo implementation : index.getAllKnownImplementors(ResteasyDotNames.DYNAMIC_FEATURE)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{implementation.name().toString()}));
        }
        if (app.size() > 1) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (AnnotationInstance annotationInstance : app) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(annotationInstance.target().asClass().name().toString());
            }
            throw new RuntimeException("Multiple classes ( " + sb.toString() + ") have been annotated with @ApplicationPath which is currently not supported");
        }
        String path = null;
        String appClass = null;
        if (!app.isEmpty()) {
            AnnotationInstance appPath = (AnnotationInstance)app.iterator().next();
            path = appPath.value().asString();
            appClass = appPath.target().asClass().name().toString();
        } else {
            path = this.resteasyConfig.path;
        }
        String mappingPath = path.endsWith("/") ? path + "*" : path + "/*";
        Collection paths = index.getAnnotations(ResteasyDotNames.PATH);
        if (paths != null && !paths.isEmpty()) {
            if (path.equals("/")) {
                filterProducer.produce((BuildItem)FilterBuildItem.builder((String)JAX_RS_FILTER_NAME, (String)ResteasyFilter.class.getName()).setLoadOnStartup(1).addFilterServletNameMapping("default", DispatcherType.REQUEST).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ResteasyFilter.class.getName()}));
            } else {
                servletProducer.produce((BuildItem)ServletBuildItem.builder((String)JAX_RS_SERVLET_NAME, (String)HttpServlet30Dispatcher.class.getName()).setLoadOnStartup(1).addMapping(mappingPath).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{HttpServlet30Dispatcher.class.getName()}));
            }
            HashSet<Object> resources = new HashSet<Object>();
            HashSet<DotName> pathInterfaces = new HashSet<DotName>();
            HashSet<ClassInfo> withoutDefaultCtor = new HashSet<ClassInfo>();
            for (AnnotationInstance annotation : paths) {
                if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                ClassInfo clazz = annotation.target().asClass();
                if (!Modifier.isInterface(clazz.flags())) {
                    Iterator className = clazz.name().toString();
                    resources.add(className);
                    reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
                    if (clazz.hasNoArgsConstructor()) continue;
                    withoutDefaultCtor.add(clazz);
                    continue;
                }
                pathInterfaces.add(clazz.name());
            }
            for (DotName iface : pathInterfaces) {
                Collection implementors = index.getAllKnownImplementors(iface);
                for (ClassInfo implementor : implementors) {
                    String className = implementor.name().toString();
                    reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
                    resources.add(className);
                }
            }
            if (!resources.isEmpty()) {
                servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.scanned.resources", String.join((CharSequence)",", resources)));
            }
            servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.servlet.mapping.prefix", path));
            if (appClass != null) {
                servletContextParams.produce((BuildItem)new ServletInitParamBuildItem(JAX_RS_APPLICATION_PARAMETER_NAME, appClass));
            }
            for (ClassInfo classInfo : withoutDefaultCtor) {
                if (classInfo.superClassType() == null || !classInfo.superClassType().name().equals((Object)DotNames.OBJECT)) {
                    return;
                }
                boolean hasNonJaxRSAnnotations = false;
                for (AnnotationInstance instance : classInfo.classAnnotations()) {
                    if (instance.name().toString().startsWith("javax.ws.rs")) continue;
                    hasNonJaxRSAnnotations = true;
                    break;
                }
                if (hasNonJaxRSAnnotations) continue;
                String name = classInfo.name().toString();
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(name, (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

                    @Override
                    public ClassVisitor apply(String className, ClassVisitor classVisitor) {
                        ClassVisitor cv = new ClassVisitor(393216, classVisitor){

                            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                super.visit(version, access, name, signature, superName, interfaces);
                                MethodVisitor ctor = this.visitMethod(1, "<init>", "()V", null, null);
                                ctor.visitCode();
                                ctor.visitVarInsn(25, 0);
                                ctor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
                                ctor.visitInsn(177);
                                ctor.visitMaxs(1, 1);
                                ctor.visitEnd();
                            }
                        };
                        return cv;
                    }
                }));
            }
        } else {
            return;
        }
        block10: for (DotName annotationType : RESTEASY_PARAM_ANNOTATIONS) {
            Collection instances = index.getAnnotations(annotationType);
            for (AnnotationInstance instance : instances) {
                MethodParameterInfo param = instance.target().asMethodParameter();
                if (param.name() != null) continue;
                log.warnv("Detected RESTEasy annotation {0} on method parameter {1}.{2} with no name. Either specify its name, or tell your compiler to enable debug info (-g) or parameter names (-parameters). This message is only logged for the first such parameter.", (Object)instance.name(), (Object)param.method().declaringClass(), (Object)param.method().name());
                break block10;
            }
        }
        this.registerReflectionForSerialization(reflectiveClass, reflectiveHierarchy, combinedIndexBuildItem);
    }

    @BuildStep
    void registerProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServletInitParamBuildItem> servletContextParams, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem) {
        if (jaxrsProvidersToRegisterBuildItem.useBuiltIn()) {
            servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.use.builtin.providers", "true"));
            if (!jaxrsProvidersToRegisterBuildItem.getContributedProviders().isEmpty()) {
                servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.providers", String.join((CharSequence)",", jaxrsProvidersToRegisterBuildItem.getContributedProviders())));
            }
        } else {
            servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.use.builtin.providers", "false"));
            servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.providers", String.join((CharSequence)",", jaxrsProvidersToRegisterBuildItem.getProviders())));
        }
        if (this.commonConfig.gzip.enabled) {
            this.commonConfig.gzip.maxInput.ifPresent(maxSize -> servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.gzip.max.input", Integer.toString(maxSize))));
        }
        for (String providerToRegister : jaxrsProvidersToRegisterBuildItem.getProviders()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{providerToRegister}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{ServletConfigSource.class, ServletContextConfigSource.class, FilterConfigSource.class}));
        unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(b -> jaxrsProvidersToRegisterBuildItem.getProviders().contains(b.getBeanClass().toString())));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void setupInjection(ResteasyTemplate template, BuildProducer<ServletInitParamBuildItem> servletContextParams, BeanContainerBuildItem beanContainerBuildItem, List<ProxyUnwrapperBuildItem> proxyUnwrappers) {
        ArrayList<Function> unwrappers = new ArrayList<Function>();
        for (ProxyUnwrapperBuildItem i : proxyUnwrappers) {
            unwrappers.add(i.getUnwrapper());
        }
        template.setupIntegration(beanContainerBuildItem.getValue(), unwrappers);
        servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.injector.factory", QuarkusInjectorFactory.class.getName()));
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyDotNames.PATH, this.resteasyConfig.singletonResources ? BuiltinScope.SINGLETON.getName() : null));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyDotNames.APPLICATION_PATH, BuiltinScope.SINGLETON.getName()));
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                ClassInfo clazz = transformationContext.getTarget().asClass();
                if (clazz.classAnnotation(ResteasyDotNames.PROVIDER) != null && clazz.annotations().containsKey(DotNames.INJECT) && !BuiltinScope.isIn((Iterable)clazz.classAnnotations())) {
                    transformationContext.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0]).done();
                }
            }
        });
    }

    @BuildStep
    void setupFilter(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RolesFilterRegistrar.class.getName()));
    }

    @BuildStep
    JaxbEnabledBuildItem enableJaxb() {
        return new JaxbEnabledBuildItem();
    }

    private void registerReflectionForSerialization(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, CombinedIndexBuildItem combinedIndexBuildItem) {
        IndexView index = combinedIndexBuildItem.getIndex();
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector", "com.fasterxml.jackson.databind.ser.std.SqlDateSerializer"}));
        for (AnnotationInstance annotation : index.getAnnotations(JSONB_ANNOTATION)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{annotation.target().asClass().name().toString()}));
        }
        for (DotName annotationType : METHOD_ANNOTATIONS) {
            Collection instances = index.getAnnotations(annotationType);
            for (AnnotationInstance instance : instances) {
                MethodInfo method = instance.target().asMethod();
                if (ResteasyScanningProcessor.isReflectionDeclarationRequiredFor(method.returnType())) {
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(method.returnType()));
                }
                for (short i = 0; i < method.parameters().size(); i = (short)(i + 1)) {
                    Type parameterType = (Type)method.parameters().get(i);
                    if (!ResteasyScanningProcessor.isReflectionDeclarationRequiredFor(parameterType) || ResteasyScanningProcessor.hasAnnotation(method, i, ResteasyDotNames.CONTEXT)) continue;
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(parameterType));
                }
            }
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{ViolationReport.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{ResteasyConstraintViolation.class.getName()}));
    }

    private static boolean isReflectionDeclarationRequiredFor(Type type) {
        DotName className = ResteasyScanningProcessor.getClassName(type);
        return className != null && !TYPES_IGNORED_FOR_REFLECTION.contains(className);
    }

    private static DotName getClassName(Type type) {
        switch (type.kind()) {
            case CLASS: 
            case PARAMETERIZED_TYPE: {
                return type.name();
            }
            case ARRAY: {
                return ResteasyScanningProcessor.getClassName(type.asArrayType().component());
            }
        }
        return null;
    }

    private static boolean hasAnnotation(MethodInfo method, short paramPosition, DotName annotation) {
        for (AnnotationInstance annotationInstance : method.annotations()) {
            AnnotationTarget target = annotationInstance.target();
            if (target == null || target.kind() != AnnotationTarget.Kind.METHOD_PARAMETER || target.asMethodParameter().position() != paramPosition || !annotationInstance.name().equals((Object)annotation)) continue;
            return true;
        }
        return false;
    }

    static {
        JAX_RS_FILTER_NAME = JAVAX_WS_RS_APPLICATION = Application.class.getName();
        JAX_RS_SERVLET_NAME = JAVAX_WS_RS_APPLICATION;
        JSONB_ANNOTATION = DotName.createSimple((String)"javax.json.bind.annotation.JsonbAnnotation");
        TYPES_IGNORED_FOR_REFLECTION = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.json.JsonObject"), DotName.createSimple((String)"javax.json.JsonArray"), DotName.createSimple((String)Response.class.getName()), DotName.createSimple((String)AsyncResponse.class.getName()), DotName.createSimple((String)"io.vertx.core.json.JsonArray"), DotName.createSimple((String)"io.vertx.core.json.JsonObject")));
        METHOD_ANNOTATIONS = new DotName[]{ResteasyDotNames.GET, ResteasyDotNames.HEAD, ResteasyDotNames.DELETE, ResteasyDotNames.OPTIONS, ResteasyDotNames.PATCH, ResteasyDotNames.POST, ResteasyDotNames.PUT};
        RESTEASY_PARAM_ANNOTATIONS = new DotName[]{ResteasyDotNames.RESTEASY_QUERY_PARAM, ResteasyDotNames.RESTEASY_FORM_PARAM, ResteasyDotNames.RESTEASY_COOKIE_PARAM, ResteasyDotNames.RESTEASY_PATH_PARAM, ResteasyDotNames.RESTEASY_HEADER_PARAM, ResteasyDotNames.RESTEASY_MATRIX_PARAM};
        log = Logger.getLogger((String)"io.quarkus.resteasy");
    }

    @ConfigRoot
    static final class ResteasyConfig {
        @ConfigItem(defaultValue="true")
        boolean singletonResources;
        @ConfigItem(defaultValue="/")
        String path;

        ResteasyConfig() {
        }
    }
}

