/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.deployment.SecurityTransformerUtils;
import io.quarkus.resteasy.runtime.ExceptionMapperRecorder;
import io.quarkus.resteasy.runtime.ForbiddenExceptionMapper;
import io.quarkus.resteasy.runtime.JaxRsSecurityConfig;
import io.quarkus.resteasy.runtime.NotFoundExceptionMapper;
import io.quarkus.resteasy.runtime.UnauthorizedExceptionMapper;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.security.spi.AdditionalSecuredClassesBuildIem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class ResteasyBuiltinsProcessor {
    protected static final String META_INF_RESOURCES = "META-INF/resources";

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.resteasy");
    }

    @BuildStep
    void setUpDenyAllJaxRs(CombinedIndexBuildItem index, JaxRsSecurityConfig config, ResteasyDeploymentBuildItem resteasyDeployment, BuildProducer<AdditionalSecuredClassesBuildIem> additionalSecuredClasses) {
        if (config.denyJaxRs) {
            HashSet<ClassInfo> classes = new HashSet<ClassInfo>();
            List resourceClasses = resteasyDeployment.getDeployment().getScannedResourceClasses();
            for (String className : resourceClasses) {
                ClassInfo classInfo = index.getIndex().getClassByName(DotName.createSimple((String)className));
                if (SecurityTransformerUtils.hasSecurityAnnotation(classInfo)) continue;
                classes.add(classInfo);
            }
            additionalSecuredClasses.produce((BuildItem)new AdditionalSecuredClassesBuildIem(classes));
        }
    }

    @BuildStep
    void setUpSecurityExceptionMappers(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(UnauthorizedExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(ForbiddenExceptionMapper.class.getName()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void setupExceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, HttpRootPathBuildItem httpRoot, ExceptionMapperRecorder recorder) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(NotFoundExceptionMapper.class.getName()));
        recorder.setHttpRoot(httpRoot.getRootPath());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addStaticResourcesExceptionMapper(ApplicationArchivesBuildItem applicationArchivesBuildItem, ExceptionMapperRecorder recorder) {
        recorder.setStaticResourceRoots(applicationArchivesBuildItem.getAllApplicationArchives().stream().map(i -> i.getArchiveRoot().resolve(META_INF_RESOURCES).toAbsolutePath().toString()).collect(Collectors.toSet()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addAdditionalEndpointsExceptionMapper(List<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, ExceptionMapperRecorder recorder, HttpRootPathBuildItem httpRoot) {
        List endpoints = displayableEndpoints.stream().map(displayableAdditionalBuildItem -> displayableAdditionalBuildItem.getEndpoint().substring(1)).sorted().collect(Collectors.toList());
        recorder.setAdditionalEndpoints(endpoints);
    }
}

