/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.runtime.ResteasyVertxConfig;
import io.quarkus.resteasy.runtime.standalone.ResteasyStandaloneRecorder;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.vertx.core.Handler;
import java.util.Optional;
import java.util.concurrent.Executor;

public class ResteasyStandaloneBuildStep {
    private static final int REST_ROUTE_ORDER_OFFSET = 500;

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void staticInit(ResteasyStandaloneRecorder recorder, Capabilities capabilities, ResteasyDeploymentBuildItem deployment, ApplicationArchivesBuildItem applicationArchivesBuildItem, ResteasyInjectionReadyBuildItem resteasyInjectionReady, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<ResteasyStandaloneBuildItem> standalone) throws Exception {
        if (capabilities.isPresent("io.quarkus.servlet")) {
            return;
        }
        if (deployment != null) {
            recorder.staticInit(deployment.getDeployment(), httpRootPathBuildItem.relativePath(deployment.getRootPath()));
            standalone.produce((BuildItem)new ResteasyStandaloneBuildItem(deployment.getRootPath()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void boot(ShutdownContextBuildItem shutdown, ResteasyStandaloneRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<DefaultRouteBuildItem> defaultRoutes, BuildProducer<RouteBuildItem> routes, BuildProducer<FilterBuildItem> filterBuildItemBuildProducer, CoreVertxBuildItem vertx, ResteasyStandaloneBuildItem standalone, Optional<RequireVirtualHttpBuildItem> requireVirtual, ExecutorBuildItem executorBuildItem, ResteasyVertxConfig resteasyVertxConfig) throws Exception {
        if (standalone == null) {
            return;
        }
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY));
        Handler handler = recorder.vertxRequestHandler(vertx.getVertx(), (Executor)executorBuildItem.getExecutorProxy(), resteasyVertxConfig);
        Handler failureHandler = recorder.vertxFailureHandler(vertx.getVertx(), (Executor)executorBuildItem.getExecutorProxy(), resteasyVertxConfig);
        filterBuildItemBuildProducer.produce((BuildItem)FilterBuildItem.ofAuthenticationFailureHandler((Handler)failureHandler));
        routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute(standalone.deploymentRootPath, Integer.valueOf(20500)).handler(handler).build());
        Object matchPath = standalone.deploymentRootPath;
        matchPath = ((String)matchPath).endsWith("/") ? (String)matchPath + "*" : (String)matchPath + "/*";
        routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute((String)matchPath, Integer.valueOf(20500)).handler(handler).build());
        recorder.start((ShutdownContext)shutdown, requireVirtual.isPresent());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public FilterBuildItem addDefaultAuthFailureHandler(ResteasyStandaloneRecorder recorder) {
        return new FilterBuildItem(recorder.defaultAuthFailureHandler(), 199);
    }

    public static final class ResteasyStandaloneBuildItem
    extends SimpleBuildItem {
        final String deploymentRootPath;

        public ResteasyStandaloneBuildItem(String deploymentRootPath) {
            this.deploymentRootPath = deploymentRootPath.startsWith("/") ? deploymentRootPath : "/" + deploymentRootPath;
        }
    }
}

