/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.deployment.RestPathAnnotationProcessor;
import io.quarkus.resteasy.runtime.AuthenticationCompletionExceptionMapper;
import io.quarkus.resteasy.runtime.AuthenticationFailedExceptionMapper;
import io.quarkus.resteasy.runtime.AuthenticationRedirectExceptionMapper;
import io.quarkus.resteasy.runtime.CompositeExceptionMapper;
import io.quarkus.resteasy.runtime.EagerSecurityFilter;
import io.quarkus.resteasy.runtime.ExceptionMapperRecorder;
import io.quarkus.resteasy.runtime.ForbiddenExceptionMapper;
import io.quarkus.resteasy.runtime.JaxRsSecurityConfig;
import io.quarkus.resteasy.runtime.NotFoundExceptionMapper;
import io.quarkus.resteasy.runtime.SecurityContextFilter;
import io.quarkus.resteasy.runtime.StandardSecurityCheckInterceptor;
import io.quarkus.resteasy.runtime.UnauthorizedExceptionMapper;
import io.quarkus.resteasy.runtime.vertx.JsonArrayReader;
import io.quarkus.resteasy.runtime.vertx.JsonArrayWriter;
import io.quarkus.resteasy.runtime.vertx.JsonObjectReader;
import io.quarkus.resteasy.runtime.vertx.JsonObjectWriter;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.security.spi.AdditionalSecuredMethodsBuildItem;
import io.quarkus.security.spi.SecurityTransformerUtils;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.devmode.RouteDescriptionBuildItem;
import io.quarkus.vertx.http.runtime.devmode.AdditionalRouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteDescription;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class ResteasyBuiltinsProcessor {
    protected static final String META_INF_RESOURCES = "META-INF/resources";
    private static final Logger LOG = Logger.getLogger(ResteasyBuiltinsProcessor.class);

    @BuildStep
    void setUpDenyAllJaxRs(CombinedIndexBuildItem index, JaxRsSecurityConfig config, ResteasyDeploymentBuildItem resteasyDeployment, BuildProducer<AdditionalSecuredMethodsBuildItem> additionalSecuredClasses) {
        if (resteasyDeployment != null && (config.denyJaxRs || config.defaultRolesAllowed.isPresent())) {
            ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
            List resourceClasses = resteasyDeployment.getDeployment().getScannedResourceClasses();
            for (String className : resourceClasses) {
                ClassInfo classInfo = index.getIndex().getClassByName(DotName.createSimple((String)className));
                if (classInfo == null) {
                    throw new IllegalStateException("Unable to find class info for " + className);
                }
                ResteasyBuiltinsProcessor.addAllUnannotatedEndpoints(index, classInfo, methods);
                Collection<ClassInfo> interfaces = RestPathAnnotationProcessor.getAllClassInterfaces(index, List.of(classInfo), new ArrayList<ClassInfo>());
                if (interfaces.isEmpty()) continue;
                ArrayList<MethodInfo> interfaceEndpoints = new ArrayList<MethodInfo>();
                for (ClassInfo anInterface : interfaces) {
                    ResteasyBuiltinsProcessor.addUnannotatedEndpoints(index, anInterface, interfaceEndpoints);
                }
                if (interfaceEndpoints.isEmpty()) continue;
                block2: for (MethodInfo interfaceEndpoint : interfaceEndpoints) {
                    if (!interfaceEndpoint.isDefault()) continue;
                    for (MethodInfo endpoint : methods) {
                        boolean nameParamsMatch = endpoint.name().equals(interfaceEndpoint.name()) && interfaceEndpoint.parameterTypes().equals(endpoint.parameterTypes());
                        if (!nameParamsMatch) continue;
                        Predicate<DotName> isEndpointInterface = arg_0 -> ((DotName)interfaceEndpoint.declaringClass().name()).equals(arg_0);
                        if (!endpoint.declaringClass().interfaceNames().stream().anyMatch(isEndpointInterface)) continue;
                        continue block2;
                    }
                    String configProperty = config.denyJaxRs ? "quarkus.security.jaxrs.deny-unannotated-endpoints" : "quarkus.security.jaxrs.default-roles-allowed";
                    LOG.warn((Object)("Default interface method '" + String.valueOf(interfaceEndpoint) + "' cannot be secured with the '" + configProperty + "' configuration property. Please implement this method for CDI interceptor binding to work"));
                }
            }
            if (!methods.isEmpty()) {
                if (config.denyJaxRs) {
                    additionalSecuredClasses.produce((BuildItem)new AdditionalSecuredMethodsBuildItem(methods));
                } else {
                    additionalSecuredClasses.produce((BuildItem)new AdditionalSecuredMethodsBuildItem(methods, config.defaultRolesAllowed));
                }
            }
        }
    }

    private static void addAllUnannotatedEndpoints(CombinedIndexBuildItem index, ClassInfo classInfo, List<MethodInfo> methods) {
        if (classInfo == null) {
            return;
        }
        ResteasyBuiltinsProcessor.addUnannotatedEndpoints(index, classInfo, methods);
        if (classInfo.superClassType() != null && !classInfo.superClassType().name().equals((Object)DotName.OBJECT_NAME)) {
            ResteasyBuiltinsProcessor.addAllUnannotatedEndpoints(index, index.getIndex().getClassByName(classInfo.superClassType().name()), methods);
        }
    }

    private static void addUnannotatedEndpoints(CombinedIndexBuildItem index, ClassInfo classInfo, List<MethodInfo> methods) {
        if (!SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)classInfo)) {
            for (MethodInfo methodInfo : classInfo.methods()) {
                if (!RestPathAnnotationProcessor.isRestEndpointMethod(index, methodInfo) || SecurityTransformerUtils.hasSecurityAnnotation((MethodInfo)methodInfo)) continue;
                methods.add(methodInfo);
            }
        }
    }

    @BuildStep
    void setUpSecurity(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItem, Capabilities capabilities) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(UnauthorizedExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(ForbiddenExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AuthenticationFailedExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AuthenticationRedirectExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AuthenticationCompletionExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(CompositeExceptionMapper.class.getName()));
        if (capabilities.isPresent("io.quarkus.security")) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(SecurityContextFilter.class.getName()));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityContextFilter.class));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(EagerSecurityFilter.class.getName()));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(EagerSecurityFilter.class));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(StandardSecurityCheckInterceptor.RolesAllowedInterceptor.class));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(StandardSecurityCheckInterceptor.PermissionsAllowedInterceptor.class));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(StandardSecurityCheckInterceptor.PermitAllInterceptor.class));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(StandardSecurityCheckInterceptor.AuthenticatedInterceptor.class));
        }
    }

    @BuildStep
    void vertxProviders(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonArrayReader.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonArrayWriter.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonObjectReader.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonObjectWriter.class.getName()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void setupExceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, HttpRootPathBuildItem httpRoot, ExceptionMapperRecorder recorder) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(NotFoundExceptionMapper.class.getName()));
        recorder.setHttpRoot(httpRoot.getRootPath());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addStaticResourcesExceptionMapper(ApplicationArchivesBuildItem applicationArchivesBuildItem, ExceptionMapperRecorder recorder) {
        recorder.setStaticResourceRoots(applicationArchivesBuildItem.getAllApplicationArchives().stream().map(i -> (String)i.apply(t -> {
            Path p = t.getPath(META_INF_RESOURCES);
            return p == null ? null : p.toAbsolutePath().toString();
        })).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addAdditionalEndpointsExceptionMapper(List<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, ExceptionMapperRecorder recorder, HttpRootPathBuildItem httpRoot) {
        List endpoints = displayableEndpoints.stream().map(displayableAdditionalBuildItem -> new AdditionalRouteDescription(displayableAdditionalBuildItem.getEndpoint(httpRoot), displayableAdditionalBuildItem.getDescription())).sorted().collect(Collectors.toList());
        recorder.setAdditionalEndpoints(endpoints);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addReactiveRoutesExceptionMapper(List<RouteDescriptionBuildItem> routeDescriptions, ExceptionMapperRecorder recorder, HttpRootPathBuildItem httpRoot) {
        ArrayList<RouteDescription> reactiveRoutes = new ArrayList<RouteDescription>();
        for (RouteDescriptionBuildItem description : routeDescriptions) {
            reactiveRoutes.add(description.getDescription());
        }
        recorder.setReactiveRoutes(reactiveRoutes);
    }
}

