/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.jackson.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.common.deployment.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.jackson.runtime.ObjectMapperProducer;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class ResteasyJacksonProcessor {
    private static final DotName OBJECT_MAPPER = DotName.createSimple((String)ObjectMapper.class.getName());
    private static final DotName CONTEXT_RESOLVER = DotName.createSimple((String)ContextResolver.class.getName());
    private static final String QUARKUS_CONTEXT_RESOLVER_NAME = "io.quarkus.resteasy.jackson.runtime.QuarkusObjectMapperContextResolver";

    @BuildStep
    void build(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem("resteasy-jackson"));
    }

    @BuildStep
    void register(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, final BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProvider, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<UnremovableBeanBuildItem> unremovable) {
        IndexView index = combinedIndexBuildItem.getIndex();
        if (this.hasCustomContextResolverBeenSupplied(index)) {
            return;
        }
        this.generateObjectMapperContextResolver(new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, name, data));
            }
        });
        jaxrsProvider.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QUARKUS_CONTEXT_RESOLVER_NAME));
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ObjectMapperProducer.class));
        Set<String> userSuppliedProducers = this.getUserSuppliedJacksonProducerBeans(index);
        if (!userSuppliedProducers.isEmpty()) {
            unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(userSuppliedProducers)));
        }
    }

    private boolean hasCustomContextResolverBeenSupplied(IndexView index) {
        for (ClassInfo contextResolver : index.getAllKnownImplementors(CONTEXT_RESOLVER)) {
            if (contextResolver.classAnnotation(DotName.createSimple((String)Provider.class.getName())) == null) continue;
            for (Type interfacesType : contextResolver.interfaceTypes()) {
                Type firstGenericType;
                List contextResolverGenericArguments;
                if (!CONTEXT_RESOLVER.equals((Object)interfacesType.name()) || !(interfacesType instanceof ParameterizedType) || (contextResolverGenericArguments = interfacesType.asParameterizedType().arguments()).size() != 1 || !((firstGenericType = (Type)contextResolverGenericArguments.get(0)) instanceof ClassType) || !firstGenericType.asClassType().name().equals((Object)OBJECT_MAPPER)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getUserSuppliedJacksonProducerBeans(IndexView index) {
        HashSet<String> result = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotName.createSimple((String)"javax.enterprise.inject.Produces"))) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || !OBJECT_MAPPER.equals((Object)annotation.target().asMethod().returnType().name())) continue;
            result.add(annotation.target().asMethod().declaringClass().name().toString());
        }
        return result;
    }

    private void generateObjectMapperContextResolver(ClassOutput classOutput) {
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(QUARKUS_CONTEXT_RESOLVER_NAME).interfaces(new Class[]{ContextResolver.class}).signature("Ljava/lang/Object;Ljavax/ws/rs/ext/ContextResolver<Lcom/fasterxml/jackson/databind/ObjectMapper;>;").build();){
            cc.addAnnotation(Provider.class);
            FieldDescriptor instance = ((FieldCreator)cc.getFieldCreator("INSTANCE", ObjectMapper.class).setModifiers(10)).getFieldDescriptor();
            try (MethodCreator getContext = cc.getMethodCreator("getContext", ObjectMapper.class, new Class[]{Class.class});){
                BranchResult branchResult = getContext.ifNull(getContext.readStaticField(instance));
                BytecodeCreator instanceNotNull = branchResult.falseBranch();
                instanceNotNull.returnValue(instanceNotNull.readStaticField(instance));
                BytecodeCreator instanceNull = branchResult.trueBranch();
                ResultHandle arcContainer = instanceNull.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle jsonbClass = instanceNull.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{instanceNull.load(ObjectMapper.class.getName())});
                ResultHandle instanceHandle = instanceNull.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), arcContainer, new ResultHandle[]{jsonbClass, instanceNull.loadNull()});
                ResultHandle get = instanceNull.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
                ResultHandle objectMapper = instanceNull.checkCast(get, ObjectMapper.class);
                instanceNull.writeStaticField(instance, objectMapper);
                instanceNull.returnValue(objectMapper);
            }
            var6_8 = null;
            try (MethodCreator bridgeGetContext = cc.getMethodCreator("getContext", Object.class, new Class[]{Class.class});){
                MethodDescriptor getContext = MethodDescriptor.ofMethod((String)QUARKUS_CONTEXT_RESOLVER_NAME, (String)"getContext", (String)"com.fasterxml.jackson.databind.ObjectMapper", (String[])new String[]{"java.lang.Class"});
                ResultHandle result = bridgeGetContext.invokeVirtualMethod(getContext, bridgeGetContext.getThis(), new ResultHandle[]{bridgeGetContext.getMethodParam(0)});
                bridgeGetContext.returnValue(result);
                bridgeGetContext.returnValue(bridgeGetContext.readStaticField(instance));
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
    }
}

