/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.jackson.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.jackson.runtime.QuarkusObjectMapperContextResolver;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class ResteasyJacksonProcessor {
    private static final DotName OBJECT_MAPPER = DotName.createSimple((String)ObjectMapper.class.getName());

    @BuildStep(providesCapabilities={"io.quarkus.resteasy-json"})
    void build(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem("resteasy-jackson"));
    }

    @BuildStep
    void register(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProvider, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<UnremovableBeanBuildItem> unremovable) {
        IndexView index = combinedIndexBuildItem.getIndex();
        jaxrsProvider.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QuarkusObjectMapperContextResolver.class.getName()));
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(QuarkusObjectMapperContextResolver.class));
        Set<String> userSuppliedProducers = this.getUserSuppliedJacksonProducerBeans(index);
        if (!userSuppliedProducers.isEmpty()) {
            unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(userSuppliedProducers)));
        }
    }

    private Set<String> getUserSuppliedJacksonProducerBeans(IndexView index) {
        HashSet<String> result = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || !OBJECT_MAPPER.equals((Object)annotation.target().asMethod().returnType().name())) continue;
            result.add(annotation.target().asMethod().declaringClass().name().toString());
        }
        return result;
    }
}

