/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.jsonb.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.jsonb.spi.JsonbDeserializerBuildItem;
import io.quarkus.jsonb.spi.JsonbSerializerBuildItem;
import io.quarkus.resteasy.jsonb.vertx.VertxJson;
import java.util.Arrays;
import java.util.List;

public class ResteasyJsonbProcessor {
    private static final List<String> VERTX_SERIALIZERS = Arrays.asList(VertxJson.JsonObjectSerializer.class.getName(), VertxJson.JsonArraySerializer.class.getName());
    private static final List<String> VERTX_DESERIALIZERS = Arrays.asList(VertxJson.JsonObjectDeserializer.class.getName(), VertxJson.JsonArrayDeserializer.class.getName());

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem("resteasy-jsonb"));
    }

    @BuildStep
    void capabilities(BuildProducer<CapabilityBuildItem> capability) {
        capability.produce((BuildItem)new CapabilityBuildItem("io.quarkus.resteasy-json"));
        capability.produce((BuildItem)new CapabilityBuildItem("io.quarkus.rest.jsonb"));
    }

    @BuildStep
    public void registerVertxJsonSupport(BuildProducer<JsonbSerializerBuildItem> serializers, BuildProducer<JsonbDeserializerBuildItem> deserializers) {
        serializers.produce((BuildItem)new JsonbSerializerBuildItem(VERTX_SERIALIZERS));
        deserializers.produce((BuildItem)new JsonbDeserializerBuildItem(VERTX_DESERIALIZERS));
    }
}

